/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.coalfire;

import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.FirestarterItem;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.HellishCoalOreBlock;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.PilableFallingLayerEntity;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.PilableLayerBlock;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.SimpleFuelItem;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.BlockBurntEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Coal & Fire")
@LoadFeature(module="iguanatweaksreborn:world")
public class CoalFire
extends Feature {
    public static final TagKey<Item> ITEM_ORES = ISOItemTagsProvider.create("hellish_coal_ores");
    public static final SimpleBlockWithItem CHARCOAL_LAYER = SimpleBlockWithItem.register("charcoal_layer", () -> new PilableLayerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60978_(0.4f).m_60918_(SoundType.f_154668_).m_60971_((state, blockGetter, pos) -> (Integer)state.m_61143_((Property)PilableLayerBlock.f_56581_) >= 8), Items.f_42414_));
    public static final RegistryObject<Item> FIRESTARTER = ISORegistries.ITEMS.register("firestarter", () -> new FirestarterItem(new Item.Properties().m_41487_(1).m_41499_(11)));
    public static final SimpleBlockWithItem SOUL_SAND_HELLISH_COAL_ORE = SimpleBlockWithItem.register("soul_sand_hellish_coal_ore", () -> new HellishCoalOreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50135_).m_60978_(2.0f).m_60918_(SoundType.f_56716_).m_60999_(), (IntProvider)UniformInt.m_146622_((int)1, (int)3)));
    public static final SimpleBlockWithItem SOUL_SOIL_HELLISH_COAL_ORE = SimpleBlockWithItem.register("soul_soil_hellish_coal_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50136_).m_60978_(2.0f).m_60918_(SoundType.f_56717_).m_60999_(), (IntProvider)UniformInt.m_146622_((int)1, (int)3)));
    public static final RegistryObject<Item> HELLISH_COAL = ISORegistries.ITEMS.register("hellish_coal", () -> new SimpleFuelItem(new Item.Properties().m_41486_(), 3600));
    public static final GameRules.Key<GameRules.IntegerValue> RULE_FIRESPEEDMULTIPLIER = GameRules.m_46189_((String)"iguanatweaks:fireSpeedMultiplier", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)4));
    @Config(min=0.0, max=1.0)
    @Label(name="Charcoal from burnt logs chance", description="Chance for logs to release charcoal layer when burnt")
    public static Double charcoalFromBurntLogsChance = 0.8;
    @Config
    @Label(name="No charcoal smelting and iron coal", description="If enabled, a data pack will be enabled that:\n* Removes the Charcoal recipe from smelting\n* Makes Coal Ore require an Iron Pickaxe or better to mine\n* Replaces Flint and Steel in the overworld with firestarter\n* Changes flint and steel recipe to require blaze powder")
    public static Boolean noCharcoalSmeltingAndIronCoal = true;
    @Config
    @Label(name="Two flint fire starter.Enabled", description="If true, two flints (on per hand) can start a fire")
    public static Boolean twoFlintFireStarter = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Two flint fire starter.Ignite Chance", description="Chance to ignite a block when using two flints")
    public static Double twoFlintFireStarterIgniteChance = 0.35;
    @Config(min=0.0, max=1.0)
    @Label(name="Two flint fire starter.Break Chance", description="Chance for the flint to break when using two flints")
    public static Double twoFlintFireStarterBreakChance = 0.3;
    @Config
    @Label(name="Unlit campfire", description="If true, campfires must be lit")
    public static Boolean unlitCampfires = true;
    @Config
    @Label(name="Campfire turn off under rain", description="If true, campfires will be extinguished when it starts to rain")
    public static Boolean campfireTurnOffUnderRain = true;

    public CoalFire(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("coal_fire", "Insane's Survival Overhaul No Charcoal Smelting and Iron Coal", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && noCharcoalSmeltingAndIronCoal != false);
    }

    public static boolean areCampfiresUnlit() {
        return Feature.isEnabled(CoalFire.class) && unlitCampfires != false;
    }

    public static boolean canRainTurnOffCampfires() {
        return Feature.isEnabled(CoalFire.class) && campfireTurnOffUnderRain != false;
    }

    @SubscribeEvent
    public void onBlockBurnt(BlockBurntEvent event) {
        if (!this.isEnabled() || charcoalFromBurntLogsChance == 0.0) {
            return;
        }
        if (event.getLevel().m_213780_().m_188500_() < charcoalFromBurntLogsChance && event.getState().m_204336_(BlockTags.f_13105_)) {
            PilableFallingLayerEntity.fall((Level)event.getLevel(), event.getPos(), ((Block)CHARCOAL_LAYER.block().get()).m_49966_());
        }
    }

    @SubscribeEvent
    public void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled() || !twoFlintFireStarter.booleanValue() || event.getHand() != InteractionHand.MAIN_HAND || !event.getItemStack().m_150930_(Items.f_42484_) || !event.getEntity().m_21206_().m_150930_(Items.f_42484_) || event.getEntity().m_36335_().m_41519_(Items.f_42484_) || event.getLevel().f_46443_) {
            return;
        }
        double breakMain = event.getEntity().m_217043_().m_188500_();
        double breakOff = event.getEntity().m_217043_().m_188500_();
        double ignite = event.getEntity().m_217043_().m_188500_();
        event.getEntity().m_21011_(event.getHand(), true);
        event.setCanceled(true);
        event.getEntity().m_36335_().m_41524_(event.getItemStack().m_41720_(), 15);
        if (ignite < twoFlintFireStarterIgniteChance) {
            BlockPos blockpos;
            UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), new BlockHitResult(event.getHitVec().m_82450_(), event.getHitVec().m_82434_(), event.getPos(), event.getHitVec().m_82436_()));
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockState blockstate = level.m_8055_(blockpos = context.m_8083_());
            if (!(CampfireBlock.m_51321_((BlockState)blockstate) || CandleBlock.m_152845_((BlockState)blockstate) || CandleCakeBlock.m_152910_((BlockState)blockstate))) {
                BlockPos blockpos1 = blockpos.m_121945_(context.m_43719_());
                if (BaseFireBlock.m_49255_((Level)level, (BlockPos)blockpos1, (Direction)context.m_8125_())) {
                    BlockState blockstate1 = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockpos1);
                    level.m_7731_(blockpos1, blockstate1, 11);
                    level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
                }
            } else {
                level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                level.m_142346_((Entity)player, GameEvent.f_157792_, blockpos);
            }
            event.getLevel().m_5594_(null, event.getPos(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, event.getLevel().m_213780_().m_188501_() * 0.4f + 0.8f);
        } else {
            event.getLevel().m_5594_(null, event.getPos(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, event.getLevel().m_213780_().m_188501_() * 0.4f + 1.5f);
        }
        if (breakMain < twoFlintFireStarterBreakChance) {
            event.getItemStack().m_41774_(1);
            event.getEntity().m_21190_(event.getHand());
            ForgeEventFactory.onPlayerDestroyItem((Player)event.getEntity(), (ItemStack)event.getItemStack(), (InteractionHand)event.getHand());
        }
        if (breakOff < twoFlintFireStarterBreakChance) {
            event.getEntity().m_21206_().m_41774_(1);
            event.getEntity().m_21190_(InteractionHand.OFF_HAND);
            ForgeEventFactory.onPlayerDestroyItem((Player)event.getEntity(), (ItemStack)event.getEntity().m_21206_(), (InteractionHand)InteractionHand.OFF_HAND);
        }
    }
}

