/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul;

import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul.ISOExplosion;
import insane96mcp.iguanatweaksreborn.network.message.ExplodeParticles;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@Label(name="Explosion Overhaul", description="Various changes to explosions, like higher knockback and getting hit when behind blown up blocks.")
@LoadFeature(module="iguanatweaksreborn:world")
public class ExplosionOverhaul
extends Feature {
    public static final TagKey<EntityType<?>> KNOCKBACK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("iguanatweaksreborn", "explosion_knockback_blacklist"));
    public static final TagKey<EntityType<?>> ENTITY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("iguanatweaksreborn", "explosion_entity_blacklist"));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_MOBGRIEFING = GameRules.m_46189_((String)"iguanatweaks:explosionMobGriefing", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    @Config
    @Label(name="Disable Explosion Randomness", description="Vanilla Explosions use a random number that changes the explosion power. With this enabled the ray strength will be as the explosion size.")
    public static Boolean disableExplosionRandomness = true;
    @Config
    @Label(name="Enable Poof Particles", description="Somewhere around 1.15 Mojang (for performance issues) removed the poof particles from Explosions. Keep them disabled if you have a low end PC.\nThese particles aren't shown when explosion power is <= 1")
    public static Boolean enablePoofParticles = true;
    @Config
    @Label(name="Disable Emitter Particles", description="Removes the particles spawned by the explosion.")
    public static Boolean disableEmitterParticles = true;
    @Config
    @Label(name="Knockback Scales With Size", description="While enabled knockback is greatly increased by explosion size")
    public static Boolean knockbackScalesWithSize = true;
    @Config
    @Label(name="Explosions at Half Entity", description="Explosions will start from the middle of the entity instead of feets.")
    public static Boolean explosionAtHalfEntity = true;
    @Config
    @Label(name="Explosion Affect Just Spawned Entities", description="Explosions affect even entities spawned by the explosions, like TnTs or chests content. BE AWARE that containers content will get destroyed.")
    public static Boolean affectJustSpawnedEntities = false;
    @Config
    @Label(name="Enable Flying Blocks", description="EXPERIMENTAL! This will make explosion blast blocks away. Blocks that can't land will drop the block as a TNT would have destroyed it.")
    public static Boolean enableFlyingBlocks = false;
    @Config
    @Label(name="Creeper collateral", description="If true, creepers explosions will drop no blocks.")
    public static Boolean creeperCollateral = false;
    @Config
    @Label(name="Explosion Damage calculation multiplier", description="Number in the explosion damage calculation. Vanilla is 7. Higher = More damage")
    public static Double explosionDamageCalculationMultiplier = 6.0;
    @Config
    @Label(name="Limit explosion size", description="Disabled if set to 0.")
    public static Integer limitExplosionSize = 12;
    @Config
    @Label(name="Don't stack drops", description="Like pre-1.14")
    public static Boolean dontStackDrops = true;
    @Config
    @Label(name="Don't apply to non-entities", description="If true, the overhaul will not be applied for explosions generated by non-entities. E.g. Supplementaries gunpowder")
    public static Boolean dontApplyToNonEntities = true;
    @Config
    @Label(name="Caverns and Chasms Deepers", description="If enabled and Caverns and Chasms is present, Deepers explosions will pierce through blocks more (like Breaching creepers and Angry Creepers in Enhanced AI), knockback and damage are reduced by 25%.")
    public static Boolean cavernsChasmsDeepers = true;

    public ExplosionOverhaul(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onDeeperSpawn(EntityJoinLevelEvent event) {
        if (!(this.isEnabled() && cavernsChasmsDeepers.booleanValue() && ModList.get().isLoaded("caverns_and_chasms") && event.getEntity().m_6095_() == CCEntityTypes.DEEPER.get())) {
            return;
        }
        ISOExplosion.setBaseResistanceAdd(event.getEntity(), 0.03f);
        ISOExplosion.setKnockbackMultiplier(event.getEntity(), 0.75f);
        ISOExplosion.setDamageMultiplierTag(event.getEntity(), 0.75f);
    }

    @SubscribeEvent
    public void explosionPoofParticles(ExplosionEvent.Detonate event) {
        if (!this.isEnabled() || !enablePoofParticles.booleanValue()) {
            return;
        }
        Explosion e = event.getExplosion();
        Level level = e.f_46012_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (e instanceof ISOExplosion) {
                ISOExplosion isoExplosion = (ISOExplosion)e;
                if (!isoExplosion.poofParticles) {
                    return;
                }
                ExplodeParticles.sync(level2, isoExplosion);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void replaceExplosionWithITRExplosion(ExplosionEvent.Start event) {
        ServerLevel level;
        block6: {
            block5: {
                Level level2;
                if (!this.isEnabled() || !((level2 = event.getLevel()) instanceof ServerLevel)) break block5;
                level = (ServerLevel)level2;
                if (event.getExplosion().getExploder() == null || !event.getExplosion().getExploder().m_6095_().m_204039_(ENTITY_BLACKLIST)) break block6;
            }
            return;
        }
        if (event.getExplosion().getExploder() == null && dontApplyToNonEntities.booleanValue()) {
            return;
        }
        event.setCanceled(true);
        Explosion e = event.getExplosion();
        double y = e.getPosition().f_82480_;
        if (e.f_46016_ != null && explosionAtHalfEntity.booleanValue()) {
            y += (double)e.f_46016_.m_20206_() / 2.0;
        }
        ISOExplosion.explode(level, e.f_46016_, e.m_46077_(), e.f_46019_, e.getPosition().f_82479_, y, e.getPosition().f_82481_, e.f_46017_, e.f_46009_, e.f_46010_, true);
    }

    public static boolean shouldTakeReducedKnockback(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        return entity.m_6095_().m_204039_(KNOCKBACK_BLACKLIST);
    }
}

