/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.seasons;

import com.google.common.collect.Lists;
import insane96mcp.iguanatweaksreborn.InsaneSurvivalOverhaul;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.event.HookTickToHookLureEvent;
import insane96mcp.iguanatweaksreborn.module.misc.DataPacks;
import insane96mcp.iguanatweaksreborn.module.world.seasons.TimeControlIntegration;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

@Label(name="Seasons", description="Change a few things relative to Serene Seasons")
@LoadFeature(module="iguanatweaksreborn:world", requiresMods={"sereneseasons"})
public class Seasons
extends Feature {
    public static final GameRules.Key<GameRules.BooleanValue> RULE_SEASONGRASSGROWDEATH = GameRules.m_46189_((String)"iguanatweaks:doSeasonGrassGrowDeath", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final TagKey<Block> PLANTS_TO_DECAY = ISOBlockTagsProvider.create("plants_to_decay");
    public static final TagKey<Block> PLANTS_TO_DEAD_BUSH = ISOBlockTagsProvider.create("plants_to_dead_bush");
    @Config
    @Label(name="Serene Seasons changes", description="Makes the following changes to Serene Seasons config:\n* seasonal_crops is set to false, as it's controlled by Plants Growth\n* Sets the starting season to the one in 'Starting season'")
    public static Boolean changeSereneSeasonsConfig = true;
    @Config
    @Label(name="No greenhouse glass", description="Removes greenhouse glass.")
    public static Boolean noGreenHouseGlass = true;
    @Config
    @Label(name="No Saplings in Winter", description="Saplings no longer drop in Winter.")
    public static Boolean noSaplingsInWinter = true;
    @Config
    @Label(name="Grass Decay and Growth", description="Grass and tall grass decays in Winter and regrows back in Spring. Saplings are also transformed into Dead Bushes.")
    public static Boolean grassDecayAndGrowth = true;
    @Config
    @Label(name="Starting season", description="Has no effect if 'Serene Seasons changes' is disabled")
    public static Season.SubSeason startingSeason = Season.SubSeason.EARLY_SUMMER;
    @Config(min=0.0)
    @Label(name="Time Control day night duration", description="How many minutes will day and night duration be (with this set to 10 the day will last 10 minutes and the night 10 minutes for a grand total of 20 minutes). This also adjusts the day_duration config option in Serene Seasons. Vanilla is 10. Requires Time Control mod")
    public static Double timeControlDayNightDuration = 15.0;
    @Config(min=0.0)
    @Label(name="Time Control day night shift", description="How many minutes will day and night duration be shifted based off seasons? E.g. in Mid spring / autumn the duration of day and night is vanilla, when moving off those seasons day and night will last this many minutes more/less. In mid summer / winter the duration of day and night duration will be more / less by 3 times this value. Set to 0 to disable. Requires Time Control mod")
    public static Double timeControlDayNightShift = 1.5;
    @Config
    @Label(name="Season based fishing time")
    public static Boolean seasonBasedFishingTime = true;
    public static final List<GrassTickingData> GRASS_TICKING_DATA = List.of(new GrassTickingData(Season.SubSeason.EARLY_SPRING, 1100, GrassTickingType.GROW, 12, false), new GrassTickingData(Season.SubSeason.MID_SPRING, 1100, GrassTickingType.GROW, 12, false), new GrassTickingData(Season.SubSeason.LATE_SPRING, 550, GrassTickingType.GROW, 10, false), new GrassTickingData(Season.SubSeason.EARLY_SUMMER, 275, GrassTickingType.GROW, 8, true), new GrassTickingData(Season.SubSeason.MID_SUMMER, 275, GrassTickingType.GROW, 7, true), new GrassTickingData(Season.SubSeason.LATE_SUMMER, 275, GrassTickingType.GROW, 7, true), new GrassTickingData(Season.SubSeason.EARLY_AUTUMN, 2000, GrassTickingType.DECAY, 0, false), new GrassTickingData(Season.SubSeason.MID_AUTUMN, 1000, GrassTickingType.DECAY, 0, false), new GrassTickingData(Season.SubSeason.LATE_AUTUMN, 500, GrassTickingType.DECAY, 0, false), new GrassTickingData(Season.SubSeason.EARLY_WINTER, 200, GrassTickingType.DECAY, 0, false), new GrassTickingData(Season.SubSeason.MID_WINTER, 100, GrassTickingType.DECAY, 0, false), new GrassTickingData(Season.SubSeason.LATE_WINTER, 400, GrassTickingType.DECAY, 0, false));

    public Seasons(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSurvivalOverhaul.addServerPack("serene_seasons_changes", "Insane's Survival Overhaul Serene Seasons Changes", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && noGreenHouseGlass != false);
        InsaneSurvivalOverhaul.addServerPack("no_saplings_in_winter", "Insane's Survival Overhaul No Saplings in Winter", () -> this.isEnabled() && DataPacks.disableAllDataPacks == false && noSaplingsInWinter != false);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (this.isEnabled() && changeSereneSeasonsConfig.booleanValue()) {
            ModConfig.fertility.set("general.seasonal_crops", (Object)false);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && ModList.get().isLoaded("sereneseasons");
    }

    public static void onSeasonChanged(SeasonChangedEvent.Standard event) {
        if (!Feature.isEnabled(Seasons.class) || timeControlDayNightShift == 0.0 || !ModConfig.seasons.isDimensionWhitelisted(event.getLevel().m_46472_())) {
            return;
        }
        if (ModList.get().isLoaded("timecontrol")) {
            TimeControlIntegration.updateDayNightLength((Season.SubSeason)event.getNewSeason());
        }
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (changeSereneSeasonsConfig.booleanValue()) {
            ModConfig.seasons.set("time_settings.progress_season_while_offline", (Object)false);
        }
        if (ModList.get().isLoaded("timecontrol") && timeControlDayNightDuration != 10.0) {
            ModConfig.seasons.set("time_settings.day_duration", (Object)((int)(timeControlDayNightDuration * 60.0 * 20.0 * 2.0)));
            ModConfig.seasons.dayDuration = (int)(timeControlDayNightDuration * 60.0 * 20.0 * 2.0);
        }
    }

    @SubscribeEvent
    public void onPreLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.level.m_46467_() == 0L && changeSereneSeasonsConfig.booleanValue()) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)event.level);
            seasonData.seasonCycleTicks = SeasonTime.ZERO.getSubSeasonDuration() * startingSeason.ordinal();
            seasonData.m_77762_();
            SeasonHandler.sendSeasonUpdate((Level)event.level);
            if (ModList.get().isLoaded("timecontrol")) {
                TimeControlIntegration.updateDayNightLength(startingSeason);
            }
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!(this.isEnabled() && grassDecayAndGrowth.booleanValue() && event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && event.level.m_46469_().m_46207_(RULE_SEASONGRASSGROWDEATH))) {
            return;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)event.level).getSubSeason();
        Optional<GrassTickingData> data = GrassTickingData.get(subSeason);
        if (data.isEmpty() || !data.get().shouldTick(event.level)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        level.m_46473_().m_6180_("tallGrassRandomTick");
        ChunkMap chunkMap = level.m_7726_().f_8325_;
        DistanceManager distanceManager = chunkMap.m_143145_();
        int naturalSpawnChunkCount = distanceManager.m_140816_();
        ArrayList list = Lists.newArrayListWithCapacity((int)naturalSpawnChunkCount);
        chunkMap.m_140416_().forEach(chunkHolder -> {
            LevelChunk levelChunk = chunkHolder.m_140085_();
            if (levelChunk != null) {
                list.add(new ChunkAndHolder(levelChunk, (ChunkHolder)chunkHolder));
            }
        });
        Collections.shuffle(list);
        for (ChunkAndHolder chunkAndHolder : list) {
            ChunkPos chunkPos = chunkAndHolder.chunk.m_7697_();
            if (!level.m_183438_(chunkPos.m_45588_()) || !chunkMap.m_183879_(chunkPos) && !distanceManager.shouldForceTicks(chunkPos.m_45588_())) continue;
            Seasons.tickPlantsLifeDeath(chunkMap, chunkAndHolder.chunk, data.get());
        }
        level.m_46473_().m_7238_();
    }

    private static void tickPlantsLifeDeath(ChunkMap chunkMap, LevelChunk levelChunk, GrassTickingData data) {
        ServerLevel level = chunkMap.f_140133_;
        ChunkPos chunkpos = levelChunk.m_7697_();
        int x = chunkpos.m_45604_();
        int z = chunkpos.m_45605_();
        LevelChunkSection[] levelChunkSections = levelChunk.m_7103_();
        for (int s = 0; s < levelChunkSections.length; ++s) {
            LevelChunkSection levelchunksection = levelChunkSections[s];
            if (!levelchunksection.m_63014_()) continue;
            int sectionY = levelChunk.m_151568_(s);
            int y = SectionPos.m_123223_((int)sectionY);
            int randomTickSpeed = level.m_46469_().m_46215_(GameRules.f_46143_);
            for (int t = 0; t < randomTickSpeed; ++t) {
                BlockPos pos = level.m_46496_(x, y, z, 15);
                BlockState state = levelchunksection.m_62982_(pos.m_123341_() - x, pos.m_123342_() - y, pos.m_123343_() - z);
                BlockPos abovePos = pos.m_7494_();
                if (level.m_45517_(LightLayer.SKY, abovePos) < data.lightLevel) continue;
                if (state.m_204336_(BlockTags.f_144274_)) {
                    BlockState stateUp = level.m_8055_(abovePos);
                    if (level.m_213780_().m_188503_(data.chance) == 0) {
                        if (stateUp.m_204336_(PLANTS_TO_DECAY)) {
                            level.m_7731_(abovePos, Blocks.f_50016_.m_49966_(), 3);
                            continue;
                        }
                        if (!stateUp.m_204336_(PLANTS_TO_DEAD_BUSH)) continue;
                        level.m_7731_(abovePos, Blocks.f_50036_.m_49966_(), 3);
                        continue;
                    }
                    if (!state.m_60713_(Blocks.f_50440_) || level.m_213780_().m_188503_(data.chance) != 0 || !stateUp.m_60795_()) continue;
                    Optional oPlacedFeature = level.m_9598_().m_175515_(Registries.f_256988_).m_203636_(VegetationPlacements.f_195459_);
                    oPlacedFeature.ifPresent(placedFeatureReference -> ((PlacedFeature)placedFeatureReference.m_203334_()).m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), level.f_46441_, abovePos));
                    continue;
                }
                if (!data.canGrowTall || level.m_213780_().m_188503_(data.chance) != 0) continue;
                if (state.m_60713_(Blocks.f_50034_)) {
                    DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)Blocks.f_50359_.m_49966_(), (BlockPos)pos, (int)2);
                    continue;
                }
                if (!state.m_60713_(Blocks.f_50035_)) continue;
                DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)Blocks.f_50360_.m_49966_(), (BlockPos)pos, (int)2);
            }
        }
    }

    @SubscribeEvent
    public void shouldSlowdownFishing(HookTickToHookLureEvent event) {
        float rng;
        if (!Feature.isEnabled(Seasons.class) || !seasonBasedFishingTime.booleanValue()) {
            return;
        }
        Level level = event.getHookEntity().m_9236_();
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        switch (season) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SPRING: {
                float f = 0.1f;
                break;
            }
            case SUMMER: {
                float f = 0.0f;
                break;
            }
            case AUTUMN: {
                float f = 0.2f;
                break;
            }
            case WINTER: {
                float f = rng = 0.5f;
            }
        }
        if (level.m_213780_().m_188501_() < rng) {
            event.setTick(event.getTick() - 1);
        }
    }

    public static float getDayNightCycleModifier() {
        return Feature.isEnabled(Seasons.class) && ModList.get().isLoaded("timecontrol") ? timeControlDayNightDuration.floatValue() / 10.0f : 1.0f;
    }

    public static float getDayDuration() {
        return Feature.isEnabled(Seasons.class) && ModList.get().isLoaded("timecontrol") ? timeControlDayNightDuration.floatValue() * 2.0f : 20.0f;
    }

    public record GrassTickingData(Season.SubSeason subSeason, int chance, GrassTickingType grassTickingType, int lightLevel, boolean canGrowTall) {
        public boolean shouldTick(Level level) {
            return this.chance > 0 && (this.grassTickingType == GrassTickingType.DECAY || level.m_46461_());
        }

        public static Optional<GrassTickingData> get(Season.SubSeason subSeason) {
            for (GrassTickingData grassTickingData : GRASS_TICKING_DATA) {
                if (grassTickingData.subSeason != subSeason) continue;
                return Optional.of(grassTickingData);
            }
            return Optional.empty();
        }
    }

    record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }

    public static enum GrassTickingType {
        GROW,
        DECAY;

    }
}

