/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.timber;

import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.entity.ISOFallingBlockEntity;
import insane96mcp.iguanatweaksreborn.module.world.timber.TreeInfo;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Timber Trees", description="Trees fall when cut.")
@LoadFeature(module="iguanatweaksreborn:world")
public class TimberTrees
extends JsonFeature {
    public static final TagKey<Block> TIMBER_TRUNKS = ISOBlockTagsProvider.create("timber_trunks");
    public static final TagKey<Block> ATTACHED_BLOCKS = ISOBlockTagsProvider.create("attached_blocks");
    public static final TagKey<Item> BLACKLISTED_ITEMS = ISOItemTagsProvider.create("no_timber");
    public static final ArrayList<TreeInfo> TREE_INFOS_DEFAULT = new ArrayList<TreeInfo>(List.of(new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:oak_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:oak_log_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:spruce_log")).leaves(IdTagMatcher.newId((String)"minecraft:spruce_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:birch_log")).leaves(IdTagMatcher.newId((String)"minecraft:birch_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:jungle_log")).leaves(IdTagMatcher.newId((String)"minecraft:jungle_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:dark_oak_log")).leaves(IdTagMatcher.newId((String)"minecraft:dark_oak_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:acacia_log")).leaves(IdTagMatcher.newId((String)"minecraft:acacia_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:cherry_log")).leaves(IdTagMatcher.newId((String)"minecraft:cherry_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"minecraft:mangrove_log")).leaves(IdTagMatcher.newId((String)"minecraft:mangrove_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"quark:blossom_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:trumpet_leaves")).logsSidewaysRatio(0.3f).maxDistanceFromLogs(15).decayPercentage(0.35f).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"quark:azalea_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:azalea_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"quark:ancient_log")).leaves(IdTagMatcher.newId((String)"quark:ancient_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"autumnity:maple_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:maple_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"upgrade_aquatic:river_log")).leaves(IdTagMatcher.newId((String)"upgrade_aquatic:river_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"atmospheric:rosewood_log")).leaves(IdTagMatcher.newId((String)"atmospheric:rosewood_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"atmospheric:yucca_log")).leaves(IdTagMatcher.newId((String)"atmospheric:yucca_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"atmospheric:grimwood_log")).leaves(IdTagMatcher.newId((String)"atmospheric:grimwood_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"atmospheric:kousa_log")).leaves(IdTagMatcher.newId((String)"atmospheric:kousa_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newTag((String)"iguanatweaksreborn:aspen_logs")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:aspen_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"atmospheric:laurel_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:laurel_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"environmental:pine_log")).leaves(IdTagMatcher.newId((String)"environmental:pine_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"environmental:plum_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:plum_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"environmental:willow_log")).leaves(IdTagMatcher.newId((String)"environmental:willow_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"environmental:wisteria_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:wisteria_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"caverns_and_chasms:azalea_log")).leaves(IdTagMatcher.newTag((String)"iguanatweaksreborn:azalea_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"tconstruct:greenheart_log")).leaves(IdTagMatcher.newId((String)"tconstruct:earth_slime_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"tconstruct:skyroot_log")).leaves(IdTagMatcher.newId((String)"tconstruct:sky_slime_leaves")).build(), new TreeInfo.Builder().log(IdTagMatcher.newId((String)"tconstruct:enderbark_log")).leaves(IdTagMatcher.newId((String)"tconstruct:ender_slime_leaves")).build()));
    public static final ArrayList<TreeInfo> treeInfos = new ArrayList();
    @Config
    @Label(name="Requires #minecraft:axes", description="Trees will timber only if an item in the minecraft:axes item tag is used")
    public static Boolean requiresAxe = false;
    public static final List<Direction> XZ_DIRECTIONS = List.of(Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.WEST);
    public static final List<Direction> DIRECTIONS = List.of(Direction.UP, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.WEST);

    public TimberTrees(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("tree_info.json", treeInfos, TREE_INFOS_DEFAULT, TreeInfo.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onLogBreak(BlockEvent.BreakEvent event) {
        if (!this.isEnabled() || !event.getState().m_204336_(TIMBER_TRUNKS) || !(event.getState().m_60734_() instanceof RotatedPillarBlock) || event.getState().m_61143_((Property)RotatedPillarBlock.f_55923_) != Direction.Axis.Y || requiresAxe.booleanValue() && !event.getPlayer().m_21205_().m_204117_(ItemTags.f_271207_) || event.getPlayer().m_21205_().m_204117_(BLACKLISTED_ITEMS)) {
            return;
        }
        BlockPos brokenPos = event.getPos();
        Level level = (Level)event.getLevel();
        if (level.m_8055_(brokenPos.m_122012_()).m_60713_(event.getState().m_60734_()) || level.m_8055_(brokenPos.m_122019_()).m_60713_(event.getState().m_60734_()) || level.m_8055_(brokenPos.m_122029_()).m_60713_(event.getState().m_60734_()) || level.m_8055_(brokenPos.m_122024_()).m_60713_(event.getState().m_60734_())) {
            return;
        }
        TreeInfo treeInfo = treeInfos.stream().filter(ti -> ti.log.matchesBlock(event.getState())).findFirst().orElse(new TreeInfo());
        List<BlockPos> blocks = TimberTrees.getTreeBlocks(brokenPos, event.getState(), level, treeInfo);
        Direction direction = event.getPlayer().m_6350_();
        boolean hasBrokenLeaves = false;
        for (BlockPos pos : blocks) {
            if (pos.equals((Object)brokenPos)) continue;
            BlockPos relative = new BlockPos(pos.m_123341_() - brokenPos.m_123341_(), pos.m_123342_() - brokenPos.m_123342_(), pos.m_123343_() - brokenPos.m_123343_());
            int verticalDistance = relative.m_123342_();
            int horizontalDistance = direction.m_122434_() == Direction.Axis.X ? relative.m_123341_() : relative.m_123343_();
            BlockPos fallingBlockPos = pos.m_5484_(direction, verticalDistance + (horizontalDistance *= direction.m_122421_().m_122541_().m_122540_())).m_6630_(horizontalDistance);
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(BlockTags.f_13035_) && level.m_213780_().m_188501_() < treeInfo.decayPercentage) {
                BlockEntity blockentity = state.m_155947_() ? level.m_7702_(pos) : null;
                Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockentity, (Entity)event.getPlayer(), (ItemStack)ItemStack.f_41583_);
                level.m_7471_(pos, false);
                if (hasBrokenLeaves) continue;
                level.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                hasBrokenLeaves = true;
                continue;
            }
            if (state.m_60734_() instanceof RotatedPillarBlock) {
                state = TimberTrees.rotatePillar(state, direction.m_122434_());
            }
            ISOFallingBlockEntity fallingBlock = new ISOFallingBlockEntity(level, fallingBlockPos, state, direction);
            if (state.m_155947_()) {
                fallingBlock.f_31944_ = level.m_7702_(pos).m_187482_();
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof BeehiveBlockEntity) {
                    BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)blockEntity;
                    beehiveBlockEntity.m_58748_(event.getPlayer(), state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                }
            }
            fallingBlock.m_6478_(MoverType.SELF, new Vec3(0.0, 0.1 * (double)horizontalDistance, 0.0));
            if (state.m_204336_(TIMBER_TRUNKS)) {
                fallingBlock.m_149656_(0.5f, 20);
            } else {
                fallingBlock.m_149656_(0.1f, 4);
            }
            level.m_7967_((Entity)fallingBlock);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private static List<BlockPos> getTreeBlocks(BlockPos pos, BlockState state, Level level, TreeInfo treeInfo) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        boolean foundLeaves = false;
        int checks = 0;
        int logs = 0;
        int sidewaysLogs = 0;
        int maxY = pos.m_123342_();
        IdTagMatcher validLogs = Objects.requireNonNullElseGet(treeInfo.log, () -> IdTagMatcher.newId((String)ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString()));
        ArrayDeque<BlockPos> posToCheck = new ArrayDeque<BlockPos>();
        posToCheck.add(pos.m_7494_());
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockState stateToCheck = level.m_8055_(pos.m_7494_());
        if (!validLogs.matchesBlock(stateToCheck)) {
            for (Direction dir : XZ_DIRECTIONS) {
                stateToCheck = level.m_8055_(pos.m_7494_().m_121945_(dir));
                if (!validLogs.matchesBlock(stateToCheck)) continue;
                blocks.add(blockPos.m_7949_());
                posToCheck.add(blockPos.m_7949_());
                ++logs;
                break;
            }
        } else {
            ++logs;
        }
        if (logs == 0) {
            return blocks;
        }
        blocks.add(blockPos.m_7949_());
        posToCheck.add(blockPos.m_7949_());
        IdTagMatcher validLeaves = null;
        if (treeInfo.leaves != null) {
            validLeaves = treeInfo.leaves;
        }
        boolean i = false;
        while (checks < 1536 && !posToCheck.isEmpty()) {
            float logsSidewaysRatio;
            ArrayList posToCheckTmp = new ArrayList(posToCheck);
            posToCheck.clear();
            for (BlockPos p : posToCheckTmp) {
                BlockState currState = level.m_8055_(p);
                Iterable<BlockPos> positionsToLoop = TimberTrees.getPositionsToCheck(p, currState);
                for (BlockPos positionToLoop : positionsToLoop) {
                    BlockPos posImmutable;
                    blockPos.m_122190_((Vec3i)positionToLoop);
                    stateToCheck = level.m_8055_((BlockPos)blockPos);
                    if (stateToCheck.m_60795_() || blocks.contains(posImmutable = blockPos.m_7949_())) continue;
                    boolean isLeaves = stateToCheck.m_204336_(BlockTags.f_13035_);
                    boolean isValidLeaves = validLeaves != null && validLeaves.matchesBlock(stateToCheck.m_60734_()) && (Boolean)stateToCheck.m_61143_((Property)LeavesBlock.f_54419_) == false;
                    boolean isSameLog = validLogs.matchesBlock(stateToCheck);
                    boolean isInDistance = TimberTrees.xzDistance(posImmutable, pos) <= treeInfo.maxDistanceFromLogs;
                    boolean isCurrLeaves = currState.m_204336_(BlockTags.f_13035_);
                    boolean isCorrectLeavesDistance = isLeaves && isCurrLeaves && ((Integer)stateToCheck.m_61143_((Property)LeavesBlock.f_54418_) > (Integer)currState.m_61143_((Property)LeavesBlock.f_54418_) || (Integer)stateToCheck.m_61143_((Property)LeavesBlock.f_54418_) == 7);
                    boolean isAttached = stateToCheck.m_204336_(ATTACHED_BLOCKS);
                    if (isAttached) {
                        blocks.add(posImmutable);
                        continue;
                    }
                    if (isLeaves && validLeaves == null) {
                        validLeaves = IdTagMatcher.newId((String)ForgeRegistries.BLOCKS.getKey((Object)stateToCheck.m_60734_()).toString());
                        isValidLeaves = true;
                    }
                    if (!isSameLog && !isValidLeaves || !isInDistance || isLeaves && isCurrLeaves && !isCorrectLeavesDistance) continue;
                    blocks.add(posImmutable);
                    posToCheck.add(posImmutable);
                    if (!FMLLoader.isProduction()) {
                        // empty if block
                    }
                    if (isValidLeaves) {
                        foundLeaves = true;
                    }
                    if (!isSameLog) continue;
                    if (stateToCheck.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y) {
                        ++logs;
                    } else {
                        ++sidewaysLogs;
                    }
                    if (posImmutable.m_123342_() <= maxY) continue;
                    maxY = posImmutable.m_123342_();
                }
                ++checks;
            }
            float f = logsSidewaysRatio = sidewaysLogs == 0 ? 999.0f : (float)logs / (float)sidewaysLogs;
            if (!posToCheck.isEmpty() || foundLeaves && logs + sidewaysLogs >= treeInfo.minLogs && !(logsSidewaysRatio < treeInfo.logsSidewaysRatio)) continue;
            blocks.clear();
            break;
        }
        if (maxY < pos.m_123342_() + 2) {
            blocks.clear();
        }
        return blocks;
    }

    public static Iterable<BlockPos> getPositionsToCheck(BlockPos pos, BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 1, 1));
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (Direction d : DIRECTIONS) {
            positions.add(pos.m_121945_(d));
        }
        return positions;
    }

    public static int xzDistance(BlockPos pos1, BlockPos pos2) {
        return pos1.m_175288_(pos2.m_123342_()).m_123333_((Vec3i)pos2);
    }

    public static BlockState rotatePillar(BlockState state, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
                    case Direction.Axis.X -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                    case Direction.Axis.Y -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
            case Z: {
                return switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
                    case Direction.Axis.Y -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                    default -> state;
                };
            }
        }
        return state;
    }
}

