/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.weather;

import insane96mcp.iguanatweaksreborn.module.world.weather.Foggy;
import insane96mcp.iguanatweaksreborn.module.world.weather.WeatherSavedData;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Client Weather")
@LoadFeature(module="iguanatweaksreborn:world", canBeDisabled=false)
public class ClientWeather
extends Feature {
    private static int foggyTimer = 0;
    private static int foggyTargetTime = 200;
    private static Foggy currentFoggy = Foggy.NONE;
    private static Foggy targetFoggy = Foggy.NONE;

    public ClientWeather(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!this.isEnabled() || event.phase != TickEvent.Phase.START || event.level.m_46472_() != Level.f_46428_) {
            return;
        }
        ClientWeather.tickFoggyWeather(event.level);
    }

    public static void tickFoggyWeather(Level level) {
        if (!level.f_46443_) {
            return;
        }
        if (currentFoggy != targetFoggy && ++foggyTimer >= foggyTargetTime) {
            currentFoggy = targetFoggy;
        }
    }

    public static void updateFoggy(WeatherSavedData.FoggyData foggyData) {
        foggyTimer = foggyData.timer;
        foggyTargetTime = foggyData.targetTime;
        currentFoggy = foggyData.current;
        targetFoggy = foggyData.target;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFog(ViewportEvent.RenderFog event) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.isEnabled() || event.isCanceled() || event.getCamera().m_167685_() != FogType.NONE || !((entity = event.getCamera().m_90592_()) instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_) || livingEntity.m_21023_(MobEffects.f_216964_)) {
            return;
        }
        float changingRatio = 1.0f;
        if (currentFoggy != targetFoggy) {
            changingRatio = (float)foggyTimer / (float)foggyTargetTime;
        }
        float nearDistance = currentFoggy.getNearDistance(event.getNearPlaneDistance(), targetFoggy, changingRatio);
        float farDistance = currentFoggy.getFarDistance(event.getFarPlaneDistance(), targetFoggy, changingRatio);
        if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
            nearDistance *= 0.5f;
            farDistance *= 0.5f;
        }
        event.setNearPlaneDistance(Math.min(nearDistance, event.getNearPlaneDistance()));
        event.setFarPlaneDistance(Math.min(farDistance, event.getFarPlaneDistance()));
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void debugScreen(CustomizeGuiOverlayEvent.DebugText event) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_ && !mc.m_91299_()) {
            event.getLeft().add(String.format("fT: %s, fTT: %s, cF: %s, tF: %s", new Object[]{foggyTimer, foggyTargetTime, currentFoggy, targetFoggy}));
        }
    }
}

