/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.network.message;

import insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul.ISOExplosion;
import insane96mcp.iguanatweaksreborn.network.ClientNetworkHandler;
import insane96mcp.iguanatweaksreborn.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ExplodeParticles {
    private final double x;
    private final double y;
    private final double z;
    private final float radius;
    private final boolean hasBrokenBlocks;
    private final Explosion.BlockInteraction blockInteraction;

    public ExplodeParticles(double x, double y, double z, float radius, boolean hasBrokenBlocks, Explosion.BlockInteraction blockInteraction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.hasBrokenBlocks = hasBrokenBlocks;
        this.blockInteraction = blockInteraction;
    }

    public static void encode(ExplodeParticles pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.x);
        buf.writeDouble(pkt.y);
        buf.writeDouble(pkt.z);
        buf.writeFloat(pkt.radius);
        buf.writeBoolean(pkt.hasBrokenBlocks);
        buf.m_130068_((Enum)pkt.blockInteraction);
    }

    public static ExplodeParticles decode(FriendlyByteBuf buf) {
        return new ExplodeParticles(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readBoolean(), (Explosion.BlockInteraction)buf.m_130066_(Explosion.BlockInteraction.class));
    }

    public static void handle(ExplodeParticles message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleExplosionParticles(message.x, message.y, message.z, message.radius, message.hasBrokenBlocks, message.blockInteraction));
        ctx.get().setPacketHandled(true);
    }

    public static void sync(ServerLevel level, ISOExplosion explosion) {
        ExplodeParticles msg = new ExplodeParticles(explosion.getPosition().f_82479_, explosion.getPosition().f_82480_, explosion.getPosition().f_82481_, explosion.f_46017_, !explosion.m_46081_().isEmpty(), explosion.f_46010_);
        level.m_6907_().forEach(player -> NetworkHandler.CHANNEL.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

