/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.setup;

import insane96mcp.iguanatweaksreborn.setup.ISOPackSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class IntegratedPack
implements Comparable<IntegratedPack> {
    public static final List<IntegratedPack> INTEGRATED_PACKS = new ArrayList<IntegratedPack>();
    int priority;
    PackType packType;
    String modId;
    String path;
    MutableComponent description;
    BooleanSupplier enabled;

    public IntegratedPack(int priority, PackType packType, String modId, String path, MutableComponent description, BooleanSupplier enabled) {
        this.priority = priority;
        this.packType = packType;
        this.modId = modId;
        this.path = path;
        this.description = description;
        this.enabled = enabled;
    }

    public IntegratedPack(PackType packType, String modId, String path, MutableComponent description, BooleanSupplier enabled) {
        this(0, packType, modId, path, description, enabled);
    }

    public int getPriority() {
        return this.priority;
    }

    public PackType getPackType() {
        return this.packType;
    }

    public String getPath() {
        return this.path;
    }

    public MutableComponent getDescription() {
        return this.description;
    }

    public boolean shouldBeEnabled() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public int compareTo(@NotNull IntegratedPack o) {
        return Integer.compare(this.priority, o.priority);
    }

    public String toString() {
        return "[%d] %s".formatted(this.priority, this.description.getString());
    }

    public static void addPack(IntegratedPack integratedPack) {
        int index = Collections.binarySearch(INTEGRATED_PACKS, integratedPack, Comparator.comparingInt(IntegratedPack::getPriority));
        if (index < 0) {
            index = -(index + 1);
        }
        INTEGRATED_PACKS.add(index, integratedPack);
    }

    public static void addServerPack(String modId, String path, String description, BooleanSupplier enabled) {
        IntegratedPack.addServerPack(0, modId, path, description, enabled);
    }

    public static void addServerPack(int priority, String modId, String path, String description, BooleanSupplier enabled) {
        IntegratedPack.addPack(new IntegratedPack(priority, PackType.SERVER_DATA, modId, path, Component.m_237113_((String)description), enabled));
    }

    public static void addClientPack(String modId, String path, String description, BooleanSupplier enabled) {
        IntegratedPack.addServerPack(0, modId, path, description, enabled);
    }

    public static void addClientPack(int priority, String modId, String path, String description, BooleanSupplier enabled) {
        IntegratedPack.addPack(new IntegratedPack(priority, PackType.CLIENT_RESOURCES, modId, path, Component.m_237113_((String)description), enabled));
    }

    public static void onAddPackFinders(AddPackFindersEvent event) {
        for (IntegratedPack integratedPack : INTEGRATED_PACKS) {
            if (event.getPackType() != integratedPack.getPackType() || !integratedPack.shouldBeEnabled()) continue;
            Path resourcePath = ModList.get().getModFileById(integratedPack.modId).getFile().findResource(new String[]{"integrated_packs/" + integratedPack.getPath()});
            Pack pack = Pack.m_245429_((String)(integratedPack.modId + ":" + integratedPack.getPath()), (Component)integratedPack.getDescription(), (integratedPack.shouldBeEnabled() && integratedPack.getPackType() != PackType.CLIENT_RESOURCES ? 1 : 0) != 0, path -> new PathPackResources(path, resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)(integratedPack.shouldBeEnabled() ? PackSource.f_10527_ : ISOPackSource.DISABLED));
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }
}

