/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.utils;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class MCUtils {
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("iguanatweaksreborn:anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);

    @Nullable
    public static <T extends LivingEntity> T getNearestEntity(List<? extends T> entitiesNearby, List<? extends T> entitiesToExclude, Vec3 pos) {
        double nearestDistance = -1.0;
        LivingEntity r = null;
        for (LivingEntity entity : entitiesNearby) {
            if (entitiesToExclude.contains(entity)) continue;
            double distance = entity.m_20238_(pos);
            if (nearestDistance != -1.0 && !(distance < nearestDistance)) continue;
            nearestDistance = distance;
            r = entity;
        }
        return (T)r;
    }

    public static void attackEntityIgnoreInvFrames(DamageSource source, float damage, Entity target, @Nullable LivingEntity living, boolean noKnockback) {
        float oldLastDamage;
        Optional<AttributeInstance> knockbackResistance = MCUtils.getKnockbackAttribute(living);
        float f = oldLastDamage = living == null ? 0.0f : living.f_20898_;
        if (noKnockback) {
            knockbackResistance.ifPresent(MCUtils::disableKnockback);
        }
        int lastInvulnerableTime = target.f_19802_;
        target.f_19802_ = 0;
        target.m_6469_(source, damage);
        target.f_19802_ = lastInvulnerableTime;
        if (living != null) {
            living.f_20898_ += oldLastDamage;
        }
        if (noKnockback) {
            knockbackResistance.ifPresent(MCUtils::enableKnockback);
        }
    }

    private static Optional<AttributeInstance> getKnockbackAttribute(@Nullable LivingEntity living) {
        return Optional.ofNullable(living).map(e -> e.m_21051_(Attributes.f_22278_)).filter(attribute -> !attribute.m_22109_(ANTI_KNOCKBACK_MODIFIER));
    }

    private static void disableKnockback(AttributeInstance instance) {
        instance.m_22118_(ANTI_KNOCKBACK_MODIFIER);
    }

    private static void enableKnockback(AttributeInstance instance) {
        instance.m_22130_(ANTI_KNOCKBACK_MODIFIER);
    }

    public static int getDurabilityLeft(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public static float getPercentageDurabilityLeft(ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "itemStack can't be null");
        if (!itemStack.m_41763_()) {
            return 0.0f;
        }
        return (float)MCUtils.getDurabilityLeft(itemStack) / (float)itemStack.m_41776_();
    }

    public static float computeFoodFormula(FoodProperties food, String formula) {
        Expression expression = new Expression(formula);
        try {
            EvaluationValue result = expression.with("hunger", (Object)food.m_38744_()).and("saturation_modifier", (Object)Float.valueOf(food.m_38745_())).and("effectiveness", (Object)Float.valueOf(insane96mcp.insanelib.util.MCUtils.getFoodEffectiveness((FoodProperties)food))).and("fast_food", (Object)food.m_38748_()).evaluate();
            return result.getNumberValue().floatValue();
        }
        catch (Exception ex) {
            ISOLogHelper.error("Failed to evaluate food formula: %s\n%s", formula, ex.getMessage());
            return -1.0f;
        }
    }
}

