/*
 * Decompiled with CFR 0.152.
 */
package jcsmecabricks.individualkeepinv;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class KeepInvMap
extends class_18 {
    public final HashMap<UUID, Boolean> invStateMap = new HashMap();
    public boolean keepInvDefault = false;
    public static KeepInvMap kim;
    public static final class_10741<KeepInvMap> TYPE;

    public static boolean getPlayerState(class_1657 player) {
        KeepInvMap.ensureLoaded(player);
        return KeepInvMap.kim.invStateMap.getOrDefault(player.method_5667(), KeepInvMap.kim.keepInvDefault);
    }

    public static void setPlayerState(class_1657 player, boolean value) {
        KeepInvMap.ensureLoaded(player);
        KeepInvMap.kim.invStateMap.put(player.method_5667(), value);
        kim.method_80();
    }

    public static void setDefaultState(boolean value) {
        if (kim != null) {
            KeepInvMap.kim.keepInvDefault = value;
            kim.method_80();
        }
    }

    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2487 playersNbt = new class_2487();
        for (Map.Entry<UUID, Boolean> entry : this.invStateMap.entrySet()) {
            class_2487 playerData = new class_2487();
            playerData.method_10556("invBool", entry.getValue().booleanValue());
            playersNbt.method_10566(entry.getKey().toString(), (class_2520)playerData);
        }
        nbt.method_10566("invStateCompound", (class_2520)playersNbt);
        nbt.method_10556("keepInvDefault", this.keepInvDefault);
        return nbt;
    }

    public static KeepInvMap fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        KeepInvMap map = new KeepInvMap();
        class_2487 compound = (class_2487)nbt.method_10562("invStateCompound").get();
        for (String key : compound.method_10541()) {
            UUID uuid = UUID.fromString(key);
            boolean keepInv = compound.method_10562(key).flatMap(nbt1 -> nbt.method_10577("invBool")).orElse(false);
            map.invStateMap.put(uuid, keepInv);
        }
        map.keepInvDefault = (Boolean)nbt.method_10577("keepInvDefault").get();
        return map;
    }

    public static KeepInvMap get(class_3218 world) {
        return (KeepInvMap)world.method_17983().method_17924(TYPE);
    }

    private static void ensureLoaded(class_1657 player) {
        class_1937 class_19372;
        if (kim == null && (class_19372 = player.method_73183()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            KeepInvMap.get(serverWorld);
        }
    }

    public static void onJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        kim = KeepInvMap.get(server.method_30002());
        if (!KeepInvMap.kim.invStateMap.containsKey(handler.field_14140.method_5667())) {
            KeepInvMap.kim.invStateMap.put(handler.field_14140.method_5667(), KeepInvMap.kim.keepInvDefault);
            kim.method_80();
        }
    }

    public static void onRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        KeepInvMap.ensureLoaded((class_1657)newPlayer);
        boolean keepInv = KeepInvMap.kim.invStateMap.getOrDefault(oldPlayer.method_5667(), KeepInvMap.kim.keepInvDefault);
        if (!alive && keepInv) {
            newPlayer.method_14203(oldPlayer, true);
            newPlayer.method_6033(20.0f);
        } else if (!alive) {
            newPlayer.field_7520 = 0;
            newPlayer.field_7495 = 0;
            newPlayer.field_7510 = 0.0f;
        }
    }

    static {
        TYPE = new class_10741("individualkeepinv", ctx -> new KeepInvMap(), ctx -> Codec.unit((Object)((Object)new KeepInvMap())), class_4284.field_19213);
    }
}

