/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material.modifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;

public interface IMaterialModifier {
    public IMaterialModifierType<?> getType();

    public <T, V extends GearPropertyValue<T>> Collection<V> modifyProperties(MaterialInstance var1, PartType var2, PropertyKey<T, V> var3, Collection<V> var4);

    public void appendTooltip(List<Component> var1);

    public MutableComponent modifyMaterialName(MutableComponent var1);

    public static class Helper {
        public static <T, V extends GearPropertyValue<T>> Collection<V> modifyNumberValuesWithBonusOrPenalty(PropertyKey<T, V> key, Collection<V> mods, float bonusOrPenalty) {
            if (key.property() instanceof NumberProperty) {
                ArrayList<NumberPropertyValue> ret = new ArrayList<NumberPropertyValue>();
                for (GearPropertyValue mod : mods) {
                    NumberPropertyValue numberValue = (NumberPropertyValue)mod;
                    float value = ((Float)numberValue.value()).floatValue();
                    ret.add(new NumberPropertyValue(value + Math.abs(value) * bonusOrPenalty, numberValue.operation()));
                }
                return ret;
            }
            return mods;
        }
    }
}

