/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.block.FluffyBlock;
import net.silentchaos512.gear.block.GearSmithingTableBlock;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.block.ModOreBlock;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.WildCropBlock;
import net.silentchaos512.gear.block.WoodBlock;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlock;
import net.silentchaos512.gear.block.charger.ChargerBlockEntity;
import net.silentchaos512.gear.block.charger.StarlightChargerBlock;
import net.silentchaos512.gear.block.grader.GraderBlock;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.block.stoneanvil.StoneAnvilBlock;
import net.silentchaos512.gear.crafting.recipe.alloy.CrudeAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.FabricAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.GemAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.MetalAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.SuperAlloyRecipe;
import net.silentchaos512.gear.gear.material.modifier.StarchargedMaterialModifier;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

@EventBusSubscriber(modid="silentgear", bus=EventBusSubscriber.Bus.MOD)
public final class SgBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"silentgear");
    private static final Map<Block, Block> STRIPPED_WOOD = new HashMap<Block, Block>();
    public static final DeferredBlock<DropExperienceBlock> BORT_ORE = SgBlocks.register("bort_ore", () -> SgBlocks.getOre((IntProvider)UniformInt.of((int)3, (int)7), SoundType.STONE));
    public static final DeferredBlock<DropExperienceBlock> DEEPSLATE_BORT_ORE = SgBlocks.register("deepslate_bort_ore", () -> SgBlocks.getOre((IntProvider)UniformInt.of((int)3, (int)7), SoundType.DEEPSLATE));
    public static final DeferredBlock<DropExperienceBlock> CRIMSON_IRON_ORE = SgBlocks.register("crimson_iron_ore", () -> SgBlocks.getOre((IntProvider)ConstantInt.of((int)0), SoundType.NETHER_GOLD_ORE));
    public static final DeferredBlock<DropExperienceBlock> BLACKSTONE_CRIMSON_IRON_ORE = SgBlocks.register("blackstone_crimson_iron_ore", () -> SgBlocks.getOre((IntProvider)ConstantInt.of((int)0), SoundType.GILDED_BLACKSTONE));
    public static final DeferredBlock<DropExperienceBlock> AZURE_SILVER_ORE = SgBlocks.register("azure_silver_ore", () -> SgBlocks.getOre((IntProvider)ConstantInt.of((int)0), SoundType.STONE));
    public static final DeferredBlock<Block> RAW_CRIMSON_IRON_BLOCK = SgBlocks.register("raw_crimson_iron_block", () -> SgBlocks.getRawOreBlock(SoundType.NETHER_GOLD_ORE));
    public static final DeferredBlock<Block> RAW_AZURE_SILVER_BLOCK = SgBlocks.register("raw_azure_silver_block", () -> SgBlocks.getRawOreBlock(SoundType.STONE));
    public static final DeferredBlock<Block> BORT_BLOCK = SgBlocks.register("bort_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> CRIMSON_IRON_BLOCK = SgBlocks.register("crimson_iron_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> CRIMSON_STEEL_BLOCK = SgBlocks.register("crimson_steel_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> BLAZE_GOLD_BLOCK = SgBlocks.register("blaze_gold_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> AZURE_SILVER_BLOCK = SgBlocks.register("azure_silver_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> AZURE_ELECTRUM_BLOCK = SgBlocks.register("azure_electrum_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> TYRIAN_STEEL_BLOCK = SgBlocks.register("tyrian_steel_block", SgBlocks::getStorageBlock);
    public static final DeferredBlock<Block> GEAR_SMITHING_TABLE = SgBlocks.register("gear_smithing_table", () -> new GearSmithingTableBlock(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<StoneAnvilBlock> STONE_ANVIL = SgBlocks.register("stone_anvil", () -> new StoneAnvilBlock(BlockBehaviour.Properties.of().strength(3.0f, 10.0f)));
    public static final DeferredBlock<GraderBlock> MATERIAL_GRADER = SgBlocks.register("material_grader", () -> new GraderBlock(BlockBehaviour.Properties.of().strength(5.0f, 30.0f)));
    public static final DeferredBlock<SalvagerBlock> SALVAGER = SgBlocks.register("salvager", () -> new SalvagerBlock(BlockBehaviour.Properties.of().strength(5.0f, 30.0f)));
    public static final DeferredBlock<StarlightChargerBlock> STARLIGHT_CHARGER = SgBlocks.register("starlight_charger", () -> new StarlightChargerBlock((BlockEntityType.BlockEntitySupplier<ChargerBlockEntity<StarchargedMaterialModifier>>)((BlockEntityType.BlockEntitySupplier)ChargerBlockEntity::createStarlightCharger), BlockBehaviour.Properties.of().strength(5.0f, 30.0f)));
    public static final DeferredBlock<AlloyMakerBlock<MetalAlloyRecipe>> ALLOY_FORGE = SgBlocks.register("alloy_forge", () -> new AlloyMakerBlock<MetalAlloyRecipe>(Const.METAL_ALLOY_MAKER_INFO, BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<AlloyMakerBlock<GemAlloyRecipe>> RECRYSTALLIZER = SgBlocks.register("recrystallizer", () -> new AlloyMakerBlock<GemAlloyRecipe>(Const.GEM_ALLOY_MAKER_INFO, BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<AlloyMakerBlock<FabricAlloyRecipe>> REFABRICATOR = SgBlocks.register("refabricator", () -> new AlloyMakerBlock<FabricAlloyRecipe>(Const.FABRIC_ALLOY_MAKER_INFO, BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<AlloyMakerBlock<CrudeAlloyRecipe>> CRUDE_MIXER = SgBlocks.register("crude_mixer", () -> new AlloyMakerBlock<CrudeAlloyRecipe>(Const.CRUDE_MIXER_INFO, BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.STONE)){

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return Shapes.block();
        }
    });
    public static final DeferredBlock<AlloyMakerBlock<SuperAlloyRecipe>> SUPER_MIXER = SgBlocks.register("super_mixer", () -> new AlloyMakerBlock<SuperAlloyRecipe>(Const.SUPER_MIXER_INFO, BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.METAL)){

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return Shapes.block();
        }
    });
    public static final DeferredBlock<MetalPressBlock> METAL_PRESS = SgBlocks.register("metal_press", () -> new MetalPressBlock(BlockBehaviour.Properties.of().strength(4.0f, 20.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<ModCropBlock> FLAX_PLANT = SgBlocks.registerNoItem("flax_plant", () -> new ModCropBlock(() -> SgItems.FLAX_SEEDS.get(), BlockBehaviour.Properties.of().strength(0.0f).noCollission().randomTicks().sound(SoundType.CROP)));
    public static final DeferredBlock<WildCropBlock> WILD_FLAX_PLANT = SgBlocks.registerNoItem("wild_flax_plant", () -> new WildCropBlock(BlockBehaviour.Properties.of().strength(0.0f).noCollission().sound(SoundType.CROP)));
    public static final DeferredBlock<ModCropBlock> FLUFFY_PLANT = SgBlocks.registerNoItem("fluffy_plant", () -> new ModCropBlock(() -> SgItems.FLUFFY_SEEDS.get(), BlockBehaviour.Properties.of().strength(0.0f).noCollission().randomTicks().sound(SoundType.CROP)));
    public static final DeferredBlock<WildCropBlock> WILD_FLUFFY_PLANT = SgBlocks.registerNoItem("wild_fluffy_plant", () -> new WildCropBlock(BlockBehaviour.Properties.of().strength(0.0f).noCollission().sound(SoundType.CROP)));
    public static final DeferredBlock<FluffyBlock> WHITE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.WHITE);
    public static final DeferredBlock<FluffyBlock> ORANGE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.ORANGE);
    public static final DeferredBlock<FluffyBlock> MAGENTA_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.MAGENTA);
    public static final DeferredBlock<FluffyBlock> LIGHT_BLUE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIGHT_BLUE);
    public static final DeferredBlock<FluffyBlock> YELLOW_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.YELLOW);
    public static final DeferredBlock<FluffyBlock> LIME_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIME);
    public static final DeferredBlock<FluffyBlock> PINK_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.PINK);
    public static final DeferredBlock<FluffyBlock> GRAY_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.GRAY);
    public static final DeferredBlock<FluffyBlock> LIGHT_GRAY_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.LIGHT_GRAY);
    public static final DeferredBlock<FluffyBlock> CYAN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.CYAN);
    public static final DeferredBlock<FluffyBlock> PURPLE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.PURPLE);
    public static final DeferredBlock<FluffyBlock> BLUE_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BLUE);
    public static final DeferredBlock<FluffyBlock> BROWN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BROWN);
    public static final DeferredBlock<FluffyBlock> GREEN_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.GREEN);
    public static final DeferredBlock<FluffyBlock> RED_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.RED);
    public static final DeferredBlock<FluffyBlock> BLACK_FLUFFY_BLOCK = SgBlocks.registerFluffyBlock(DyeColor.BLACK);
    public static final DeferredBlock<TorchBlock> STONE_TORCH = SgBlocks.register("stone_torch", () -> new TorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.of().noCollission().strength(0.0f).lightLevel(state -> 14).sound(SoundType.STONE)), bro -> SgBlocks.getStoneTorchItem());
    public static final DeferredBlock<WallTorchBlock> WALL_STONE_TORCH = SgBlocks.registerNoItem("wall_stone_torch", () -> new WallTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.of().noCollission().strength(0.0f).lightLevel(state -> 14).sound(SoundType.STONE).lootFrom(STONE_TORCH)));
    public static final DeferredBlock<Block> NETHERWOOD_CHARCOAL_BLOCK = SgBlocks.register("netherwood_charcoal_block", () -> new Block(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<WoodBlock> NETHERWOOD_LOG = SgBlocks.register("netherwood_log", () -> new WoodBlock(STRIPPED_WOOD::get, SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_NETHERWOOD_LOG = SgBlocks.register("stripped_netherwood_log", () -> new RotatedPillarBlock(SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final DeferredBlock<WoodBlock> NETHERWOOD_WOOD = SgBlocks.register("netherwood_wood", () -> new WoodBlock(STRIPPED_WOOD::get, SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_NETHERWOOD_WOOD = SgBlocks.register("stripped_netherwood_wood", () -> new RotatedPillarBlock(SgBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final DeferredBlock<Block> NETHERWOOD_PLANKS = SgBlocks.register("netherwood_planks", () -> new Block(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final DeferredBlock<SlabBlock> NETHERWOOD_SLAB = SgBlocks.register("netherwood_slab", () -> new SlabBlock(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final DeferredBlock<StairBlock> NETHERWOOD_STAIRS = SgBlocks.register("netherwood_stairs", () -> new StairBlock(((Block)NETHERWOOD_PLANKS.get()).defaultBlockState(), SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final DeferredBlock<FenceBlock> NETHERWOOD_FENCE = SgBlocks.register("netherwood_fence", () -> new FenceBlock(SgBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final DeferredBlock<FenceGateBlock> NETHERWOOD_FENCE_GATE = SgBlocks.register("netherwood_fence_gate", () -> new FenceGateBlock(SgBlocks.netherWoodProps(2.0f, 3.0f), SoundEvents.NETHER_WOOD_FENCE_GATE_CLOSE, SoundEvents.NETHER_WOOD_FENCE_GATE_OPEN));
    public static final DeferredBlock<DoorBlock> NETHERWOOD_DOOR = SgBlocks.register("netherwood_door", () -> new DoorBlock(BlockSetType.CRIMSON, SgBlocks.netherWoodProps(3.0f, 3.0f).noOcclusion()));
    public static final DeferredBlock<TrapDoorBlock> NETHERWOOD_TRAPDOOR = SgBlocks.register("netherwood_trapdoor", () -> new TrapDoorBlock(BlockSetType.CRIMSON, SgBlocks.netherWoodProps(3.0f, 3.0f).noOcclusion()));
    public static final DeferredBlock<LeavesBlock> NETHERWOOD_LEAVES = SgBlocks.register("netherwood_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().strength(0.2f).randomTicks().noOcclusion().sound(SoundType.GRASS)));
    public static final DeferredBlock<NetherwoodSapling> NETHERWOOD_SAPLING = SgBlocks.register("netherwood_sapling", () -> new NetherwoodSapling(BlockBehaviour.Properties.of().strength(0.0f).noCollission().randomTicks().sound(SoundType.GRASS)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_NETHERWOOD_SAPLING = SgBlocks.registerNoItem("potted_netherwood_sapling", () -> SgBlocks.makePottedPlant(NETHERWOOD_SAPLING));
    public static final DeferredBlock<PhantomLight> PHANTOM_LIGHT = SgBlocks.register("phantom_light", PhantomLight::new);

    private SgBlocks() {
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        STRIPPED_WOOD.put((Block)NETHERWOOD_LOG.get(), (Block)STRIPPED_NETHERWOOD_LOG.get());
        STRIPPED_WOOD.put((Block)NETHERWOOD_WOOD.get(), (Block)STRIPPED_NETHERWOOD_WOOD.get());
    }

    private static DropExperienceBlock getOre(IntProvider xpDrop, SoundType soundType) {
        return new ModOreBlock(xpDrop, BlockBehaviour.Properties.of().strength(4.0f, 10.0f).requiresCorrectToolForDrops().sound(soundType));
    }

    private static Block getRawOreBlock(SoundType soundType) {
        return new ModOreBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.of().strength(4.0f, 20.0f).requiresCorrectToolForDrops().sound(soundType));
    }

    private static Block getStorageBlock() {
        return new Block(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).sound(SoundType.METAL));
    }

    private static <T extends Block> DeferredBlock<T> registerNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block) {
        return SgBlocks.register(name, block, SgBlocks::defaultItem);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> block, Function<DeferredBlock<T>, Supplier<? extends BlockItem>> item) {
        DeferredBlock<T> ret = SgBlocks.registerNoItem(name, block);
        SgItems.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static DeferredBlock<FluffyBlock> registerFluffyBlock(DyeColor color) {
        return SgBlocks.register(color.getName() + "_fluffy_block", () -> new FluffyBlock(color));
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(DeferredBlock<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }

    private static Supplier<BlockItem> getStoneTorchItem() {
        return () -> new StandingAndWallBlockItem((Block)STONE_TORCH.get(), (Block)WALL_STONE_TORCH.get(), new Item.Properties(), Direction.DOWN);
    }

    private static FlowerPotBlock makePottedPlant(Supplier<? extends Block> flower) {
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, flower, BlockBehaviour.Properties.of().strength(0.0f));
        ResourceLocation flowerId = NameUtils.fromBlock((Block)flower.get());
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(flowerId, () -> potted);
        return potted;
    }

    private static BlockBehaviour.Properties netherWoodProps(float hardnessIn, float resistanceIn) {
        return BlockBehaviour.Properties.of().strength(hardnessIn, resistanceIn).sound(SoundType.WOOD);
    }

    public static <T extends Block> Collection<T> getBlocks(Class<T> clazz) {
        return BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(clazz::isInstance).map(block -> block).collect(Collectors.toList());
    }
}

