package de.pilz.alternativechunkloading.core;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;

import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import de.pilz.alternativechunkloading.Tags;
import de.pilz.alternativechunkloading.configuration.ConfigManager;
import de.pilz.alternativechunkloading.mixins.Mixins;

@IFMLLoadingPlugin.MCVersion("1.7.10")
public class AlternativeChunkloadingCore extends DummyModContainer implements IFMLLoadingPlugin, IEarlyMixinLoader {

    public static final String[] DEFAULT_TRANSFORMERS = new String[] {
        "com.gtnewhorizon.gtnhlib.core.transformer.EventBusSubTransformer" };

    static {
        ConfigManager.registerConfigs();
    }

    public AlternativeChunkloadingCore() {
        super(new ModMetadata());
        ModMetadata md = getMetadata();
        md.autogenerated = true;
        md.modId = md.name = "Alternative Chunkloading Core";
        md.parent = "alternativechunkloading";
        md.version = Tags.VERSION;
    }

    @Override
    public String[] getASMTransformerClass() {
        return new String[] {};
    }

    @Override
    public String getModContainerClass() {
        return "de.pilz.alternativechunkloading.core.AlternativeChunkloadingCore";
    }

    @Override
    public String getSetupClass() {
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {}

    @Override
    public String getAccessTransformerClass() {
        return null;
    }

    @Override
    public String getMixinConfig() {
        return "mixins.alternativechunkloading.early.json";
    }

    @Override
    public List<String> getMixins(Set<String> loadedCoreMods) {
        return IMixins.getEarlyMixins(Mixins.class, loadedCoreMods);
    }
}
