/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.rice.notice.command;

import cn.handyplus.rice.notice.constants.TabListEnum;
import cn.handyplus.rice.notice.lib.annotation.HandyCommand;
import cn.handyplus.rice.notice.lib.command.HandyCommandWrapper;
import cn.handyplus.rice.notice.lib.util.BaseUtil;
import cn.handyplus.rice.notice.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="riceNotice")
public class RiceNoticeCommand
implements TabExecutor {
    private static final String PERMISSION = "riceNotice.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getLangMsg("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Object> commands = !sender.hasPermission(PERMISSION) ? new ArrayList() : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return;
        }
        ArrayList<String> helps = new ArrayList<String>();
        helps.add("&e/riceNotice reload          &f\u91cd\u8f7d\u63d2\u4ef6");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
    }
}

