/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.rice.notice.lib.core;

import cn.handyplus.rice.notice.lib.constants.BaseConstants;
import cn.handyplus.rice.notice.lib.core.CollUtil;
import cn.handyplus.rice.notice.lib.util.HandyHttpUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public final class NetUtil {
    private NetUtil() {
    }

    public static String getLocalMacAddress() {
        Optional<String> macAddress = NetUtil.getMacAddress(NetUtil.getLocalhost());
        return macAddress.orElseGet(HandyHttpUtil::getIp);
    }

    private static Optional<String> getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    private static Optional<String> getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return Optional.empty();
        }
        byte[] mac = NetUtil.getHardwareAddress(inetAddress);
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return Optional.of(sb.toString());
        }
        return Optional.empty();
    }

    private static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> !address.isLoopbackAddress() && address instanceof Inet4Address);
        if (CollUtil.isNotEmpty(localAddressList)) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, "error:", exception);
            }
            return null;
        }
    }

    private static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    @FunctionalInterface
    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

