/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import io.github._4drian3d.vconsolelinker.ConsoleLogAppender;
import io.github._4drian3d.vconsolelinker.configuration.Configuration;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;

@Plugin(id="vconsolelinker", name="VConsoleLinker", description="Velocity Console Linker", version="1.0.0", authors={"4drian3d"})
public final class VConsoleLinker {
    @Inject
    private Injector injector;
    @Inject
    @DataDirectory
    private Path path;
    @Inject
    private Logger logger;

    @Subscribe(priority=32766)
    void onProxyInitialization(ProxyInitializeEvent event) {
        Configuration configuration;
        try {
            configuration = Configuration.load(this.path);
            if (configuration.getChannelId().isBlank() || configuration.getToken().isBlank()) {
                this.logger.error("The plugin has not yet been configured, no function will be enabled");
                return;
            }
        }
        catch (IOException e) {
            this.logger.error("An error occurred loading configuration", (Throwable)e);
            return;
        }
        this.injector = this.injector.createChildInjector(new Module[]{binder -> binder.bind(Configuration.class).toInstance((Object)configuration)});
        org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        rootLogger.addAppender((Appender)this.injector.getInstance(ConsoleLogAppender.class));
    }
}

