/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.configuration;

import io.github._4drian3d.vconsolelinker.formatter.ColorFormatter;
import io.github._4drian3d.vconsolelinker.formatter.Formatter;
import io.github._4drian3d.vconsolelinker.formatter.PlainFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public interface Configuration {
    public String getChannelId();

    public String getToken();

    public Formatter formatter();

    public static Configuration load(Path path) throws IOException {
        Path configPath = Configuration.loadFiles(path);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configPath)).build();
        CommentedConfigurationNode loaded = (CommentedConfigurationNode)loader.load();
        final String channelId = ((CommentedConfigurationNode)loaded.node(new Object[]{"channel-id"})).getString();
        final String token = ((CommentedConfigurationNode)loaded.node(new Object[]{"token"})).getString();
        final Formatter formatter = ((CommentedConfigurationNode)loaded.node(new Object[]{"color-support"})).getBoolean(true) ? new ColorFormatter() : new PlainFormatter();
        return new Configuration(){

            @Override
            public String getChannelId() {
                return channelId;
            }

            @Override
            public String getToken() {
                return token;
            }

            @Override
            public Formatter formatter() {
                return formatter;
            }
        };
    }

    private static Path loadFiles(Path path) throws IOException {
        Path configPath;
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (Files.notExists(configPath = path.resolve("config.conf"), new LinkOption[0])) {
            try (InputStream stream = Configuration.class.getClassLoader().getResourceAsStream("config.conf");){
                Files.copy(Objects.requireNonNull(stream), configPath, new CopyOption[0]);
            }
        }
        return configPath;
    }
}

