/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.formatter;

import io.github._4drian3d.vconsolelinker.formatter.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ColorFormatter
implements Formatter {
    private final Pattern RGB_PATTERN = Pattern.compile("\u001b\\[38;2;(\\d+);(\\d+);(\\d+)m");
    private final Pattern RESET_PATTERN = Pattern.compile("\u001b\\[0m");

    @Override
    public String format(String message) {
        Matcher matcher = this.RGB_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            int red = Integer.parseInt(matcher.group(1));
            int green = Integer.parseInt(matcher.group(2));
            int blue = Integer.parseInt(matcher.group(3));
            int ansiCode = this.approximateAnsiColor(red, green, blue);
            matcher.appendReplacement(builder, "\u001b[" + ansiCode + "m");
        }
        matcher.appendTail(builder);
        String clean = this.RESET_PATTERN.matcher(builder.toString()).replaceAll("\u001b[0m");
        return "```ansi\n%s\n```".formatted(clean);
    }

    private int approximateAnsiColor(int red, int green, int blue) {
        if (red > 200 && green < 80 && blue < 80) {
            return 31;
        }
        if (red < 80 && green > 200 && blue < 80) {
            return 32;
        }
        if (red > 200 && green > 200 && blue < 80) {
            return 33;
        }
        if (red < 80 && green < 80 && blue > 200) {
            return 34;
        }
        if (red > 200 && green < 80 && blue > 200) {
            return 35;
        }
        if (red < 80 && green > 200 && blue > 200) {
            return 36;
        }
        if (red > 200 && green > 200 && blue > 200) {
            return 97;
        }
        if (red < 100 && green < 100 && blue < 100) {
            return 90;
        }
        return 37;
    }
}

