/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.libs.jdwebhooks;

import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.Embed;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WebHook(@NotNull String content, @Nullable String username, @Nullable String avatarURL, @Nullable Boolean tts, @Nullable List<Embed> embeds, @Nullable Boolean allowedMentions, @Nullable String threadName) {
    public WebHook(@NotNull String content, @Nullable String username, @Nullable String avatarURL, @Nullable Boolean tts, @Nullable List<Embed> embeds, @Nullable Boolean allowedMentions, @Nullable String threadName) {
        Objects.requireNonNull(content, "content");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content = "";
        private String username;
        private String avatarURL;
        private Boolean tts;
        private List<Embed> embeds;
        private Boolean allowedMentions;
        private String threadName;

        private Builder() {
        }

        public Builder content(@NotNull String content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = Objects.requireNonNull(username);
            return this;
        }

        public Builder avatarURL(@Nullable String avatarURL) {
            this.avatarURL = avatarURL;
            return this;
        }

        public Builder tts(@Nullable Boolean tts) {
            this.tts = tts;
            return this;
        }

        public Builder embed(@NotNull Embed embed) {
            Objects.requireNonNull(embed);
            if (this.embeds == null) {
                this.embeds = new ArrayList<Embed>();
            }
            this.embeds.add(embed);
            return this;
        }

        public Builder embeds(@NotNull @NotNull List<@NotNull Embed> embeds) {
            Objects.requireNonNull(embeds);
            for (Embed embed : embeds) {
                this.embed(embed);
            }
            return this;
        }

        public Builder embeds(Embed ... embeds) {
            Objects.requireNonNull(embeds);
            for (Embed embed : embeds) {
                this.embed(embed);
            }
            return this;
        }

        public Builder allowedMentions(@Nullable Boolean allowedMentions) {
            this.allowedMentions = allowedMentions;
            return this;
        }

        public Builder threadName(@Nullable String threadName) {
            this.threadName = threadName;
            return this;
        }

        public WebHook build() {
            return new WebHook(this.content, this.username, this.avatarURL, this.tts, this.embeds, this.allowedMentions, this.threadName);
        }
    }
}

