/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.libs.jdwebhooks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.Embed;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.WebHook;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.serializer.DateSerializer;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.serializer.EmbedSerializer;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.serializer.WebHookSerializer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public final class WebHookClient {
    private static final String BASE_URL = "https://discord.com/api/webhooks/%s/%s";
    private static final String DEFAULT_AGENT = "github/4drian3d/JDWebhooks";
    private final URI webhookURL;
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final String userAgent;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (Object)new DateSerializer()).registerTypeAdapter(Embed.class, (Object)new EmbedSerializer()).registerTypeAdapter(WebHook.class, (Object)new WebHookSerializer()).create();

    private WebHookClient(Builder builder) {
        this.webhookURL = builder.uri;
        this.userAgent = builder.agent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WebHookClient fromURL(@NotNull String uri) {
        return WebHookClient.builder().uri(uri).agent(DEFAULT_AGENT).build();
    }

    public static WebHookClient from(@NotNull String id, @NotNull String token) {
        return WebHookClient.builder().credentials(id, token).agent(DEFAULT_AGENT).build();
    }

    public CompletableFuture<HttpResponse<String>> sendWebHook(@NotNull WebHook webHook) {
        Objects.requireNonNull(webHook, "webhook");
        String json = this.gson.toJson((Object)webHook);
        return this.sendRequest(json);
    }

    private CompletableFuture<HttpResponse<String>> sendRequest(String json) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.webhookURL).header("User-Agent", this.userAgent).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public static final class Builder {
        private URI uri;
        private String agent;

        private Builder() {
        }

        public Builder uri(@NotNull String uri) {
            Objects.requireNonNull(uri, "uri");
            try {
                this.uri = new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI provided", e);
            }
            return this;
        }

        public Builder credentials(@NotNull String id, @NotNull String token) {
            Objects.requireNonNull(id, "id");
            Objects.requireNonNull(token, "token");
            this.uri(WebHookClient.BASE_URL.formatted(id, token));
            return this;
        }

        public Builder agent(@NotNull String agent) {
            Objects.requireNonNull(agent, "agent");
            this.agent = agent;
            return this;
        }

        public WebHookClient build() {
            Objects.requireNonNull(this.uri, "uri");
            Objects.requireNonNull(this.agent, "agent");
            return new WebHookClient(this);
        }
    }
}

