/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.libs.jdwebhooks.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.Embed;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.serializer.CommonSerializer;
import java.lang.reflect.Type;

public final class EmbedSerializer
implements JsonSerializer<Embed>,
CommonSerializer {
    public JsonElement serialize(Embed src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.addNonNull(object, "title", src.title());
        this.addNonNull(object, "type", src.type());
        this.addNonNull(object, "description", src.description());
        this.addNonNull(object, "timestamp", src.timestamp());
        this.addNonNull(object, "color", src.color());
        this.serializeAuthor(object, src.author());
        this.serializeFooter(object, src.footer());
        this.serializeGraphicResource(object, "image", src.image());
        this.serializeGraphicResource(object, "thumbnail", src.thumbnail());
        this.serializeGraphicResource(object, "video", src.video());
        this.serializeProvider(object, src.provider());
        this.serializeFields(object, src.fields());
        return object;
    }

    private void serializeAuthor(JsonObject object, Embed.Author author) {
        if (author == null) {
            return;
        }
        JsonObject authorObject = new JsonObject();
        this.addNonNull(authorObject, "name", author.name());
        this.addNonNull(authorObject, "url", author.url());
        this.addNonNull(authorObject, "icon_url", author.iconURL());
        this.addNonNull(authorObject, "proxy_icon_url", author.proxyIconURL());
        object.add("author", (JsonElement)authorObject);
    }

    private void serializeFooter(JsonObject object, Embed.Footer footer) {
        if (footer == null) {
            return;
        }
        JsonObject footerObject = new JsonObject();
        this.addNonNull(footerObject, "text", footer.text());
        this.addNonNull(footerObject, "icon_url", footer.iconURL());
        this.addNonNull(footerObject, "proxy_icon_url", footer.proxyIconURL());
        object.add("footer", (JsonElement)footerObject);
    }

    private void serializeGraphicResource(JsonObject object, String name, Embed.GraphicResource resource) {
        if (resource == null) {
            return;
        }
        JsonObject imageObject = new JsonObject();
        this.addNonNull(imageObject, "url", resource.url());
        this.addNonNull(imageObject, "proxy_url", resource.proxyURL());
        this.addNonNull(imageObject, "height", resource.height());
        this.addNonNull(imageObject, "width", resource.width());
        object.add(name, (JsonElement)imageObject);
    }

    private void serializeProvider(JsonObject object, Embed.Provider provider) {
        if (provider == null) {
            return;
        }
        JsonObject providerObject = new JsonObject();
        this.addNonNull(providerObject, "name", provider.name());
        this.addNonNull(providerObject, "url", provider.url());
        object.add("provider", (JsonElement)providerObject);
    }

    private void serializeFields(JsonObject object, Embed.Field[] fields) {
        if (fields == null) {
            return;
        }
        JsonArray fieldArray = new JsonArray();
        for (Embed.Field field : fields) {
            JsonObject fieldObject = new JsonObject();
            this.addNonNull(fieldObject, "inline", field.inline());
            fieldObject.addProperty("name", field.name());
            fieldObject.addProperty("value", field.value());
            fieldArray.add((JsonElement)fieldObject);
        }
        object.add("fields", (JsonElement)fieldArray);
    }
}

