/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vconsolelinker.manager;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github._4drian3d.vconsolelinker.configuration.Configuration;
import io.github._4drian3d.vconsolelinker.formatter.Formatter;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.WebHook;
import io.github._4drian3d.vconsolelinker.libs.jdwebhooks.WebHookClient;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

@Singleton
public final class WebHookManager {
    private final Queue<String> logQueue = new ConcurrentLinkedQueue<String>();
    private final WebHookClient client;

    @Inject
    private WebHookManager(Configuration configuration, Logger logger) {
        this.client = WebHookClient.from(configuration.getChannelId(), configuration.getToken());
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("VConsoleLinker %s").setUncaughtExceptionHandler((thread, ex) -> logger.error("An error occurred", ex)).build());
        executor.scheduleAtFixedRate(() -> {
            String webHookOutput = this.populateLogMessage();
            if (webHookOutput != null) {
                this.client.sendWebHook(WebHook.builder().content(configuration.formatter().format(webHookOutput)).build());
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void logMessage(String string) {
        this.logQueue.add(string);
    }

    private String populateLogMessage() {
        String logMessage = this.logQueue.poll();
        if (logMessage != null) {
            if (logMessage.length() > 2000) {
                return Formatter.trimAnsi(logMessage.substring(0, 2000));
            }
            StringBuilder builder = new StringBuilder(2000);
            while (builder.length() + logMessage.length() <= 2000) {
                builder.append('\n').append(logMessage);
                logMessage = this.logQueue.poll();
                if (logMessage != null) continue;
            }
            return Formatter.trimAnsi(builder.toString());
        }
        return null;
    }
}

