/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.github.standobyte.jojo.client.ClientUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.weever.rotp_mwp.network.AddonPackets;
import net.weever.rotp_mwp.network.packets.CommonConfigPacket;
import net.weever.rotp_mwp.network.packets.ResetSyncedCommonConfigPacket;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="rotp_mwp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    static final ForgeConfigSpec commonSpec;
    private static final Common COMMON_FROM_FILE;
    private static final Common COMMON_SYNCED_TO_CLIENT;

    private static boolean isElementNonNegativeFloat(Object num, boolean moreThanZero) {
        if (num instanceof Double) {
            Double numDouble = (Double)num;
            return (numDouble > 0.0 || !moreThanZero && numDouble == 0.0) && Float.isFinite(numDouble.floatValue());
        }
        return false;
    }

    public static Common getCommonConfigInstance(boolean isClientSide) {
        return isClientSide && !ClientUtil.isLocalServer() ? COMMON_SYNCED_TO_CLIENT : COMMON_FROM_FILE;
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if ("rotp_mwp".equals(config.getModId()) && config.getType() == ModConfig.Type.COMMON) {
            Config.COMMON_FROM_FILE.onLoadOrReload();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        MinecraftServer server;
        ModConfig config = event.getConfig();
        if ("rotp_mwp".equals(config.getModId()) && config.getType() == ModConfig.Type.COMMON && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            server.func_184103_al().func_181057_v().forEach(Common.SyncedValues::syncWithClient);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(x$0 -> new Common((ForgeConfigSpec.Builder)x$0));
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON_FROM_FILE = (Common)specPair.getLeft();
        Pair syncedSpecPair = new ForgeConfigSpec.Builder().configure(builder -> new Common((ForgeConfigSpec.Builder)builder, "synced"));
        CommentedConfig config = CommentedConfig.of((ConfigFormat)InMemoryCommentedFormat.defaultInstance());
        ForgeConfigSpec syncedSpec = (ForgeConfigSpec)syncedSpecPair.getRight();
        syncedSpec.correct(config);
        syncedSpec.setConfig(config);
        COMMON_SYNCED_TO_CLIENT = (Common)syncedSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue percentageChanceToGettingAStandForMob;
        public final ForgeConfigSpec.BooleanValue useEntityWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockedStandsForMobs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockedStandActionsForMobs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> longRangeStands;
        public final ForgeConfigSpec.BooleanValue useAddonStands;
        public final ForgeConfigSpec.BooleanValue smallAnarchyWithStands;
        public final ForgeConfigSpec.BooleanValue dropStandDiscFromMobs;
        public final ForgeConfigSpec.BooleanValue spawnBoy2Man;
        public final ForgeConfigSpec.BooleanValue useWIPComboSystem;
        public final ForgeConfigSpec.BooleanValue requireStandAdvancementToSpawnMobsWithPowers;
        private boolean loaded = false;

        private Common(ForgeConfigSpec.Builder builder) {
            this(builder, (String)null);
        }

        private Common(ForgeConfigSpec.Builder builder, @Nullable String mainPath) {
            if (mainPath != null) {
                builder.push(mainPath);
            }
            builder.push("Settings");
            this.percentageChanceToGettingAStandForMob = builder.translation("rotp_mwp.config.percentageChanceToGettingAStandForMob").comment(new String[]{"    The percentage chance for a mob to get a Stand upon spawning.", "    - Default: 5%"}).defineInRange("percentageChanceToGettingAStandForMob", 5, 0, 100);
            this.useEntityWhitelist = builder.translation("rotp_mwp.config.use_entity_whitelist").comment(new String[]{"    Determines how the 'entityList' will work.", "    - false (default): Blacklist. Entities on the list are FORBIDDEN from getting powers.", "    - true: Whitelist. ONLY entities on the list CAN get powers."}).define("useEntityWhitelist", false);
            this.entityList = builder.translation("rotp_mwp.config.entity_list").comment(new String[]{"    A list of entity IDs used as either a blacklist or a whitelist.", "    Its behavior is determined by the 'useEntityWhitelist' option."}).defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityList"}), () -> Arrays.asList("rotp_harvest:harvest", "rotp_zbc:bad_soldier", "rotp_zbc:bad_tank", "rotp_zbc:bad_helicopter", "rotp_pj:pearljam", "rotp_zkq:sheer_heart", "rotp_stfn:player_arm", "rotp_stfn:player_leg", "rotp_stfn:player_head"), obj -> obj instanceof String);
            this.blockedStandsForMobs = builder.translation("rotp_mwp.config.blocked_stands").comment(new String[]{"    A blacklist of Stands that mobs cannot obtain.", "    - SOME STANDS CAUSE ISSUES: Harvest (summon), Bad Company (summon), Weather Report (optimized only for players).", "    - If you want to help fix these issues, please send crash reports to the addon's Discord thread!"}).defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"blockedStandsForMobs"}), () -> Arrays.asList("rotp_harvest:harvest_stand", "rotp_zbc:bad_company", "rotp_wr:weather_report", "rotp_ctr:catch_the_rainbow", "rotp_metallica:metallica", "rotp_zwa:white_album", "rotp_wou:wonder_of_you", "rotp_wonderofu:wonderofu", "rotp_lovers:lovers"), obj -> obj instanceof String);
            this.blockedStandActionsForMobs = builder.translation("rotp_mwp.config.blocked_actions").comment("    A blacklist of Stand abilities that mobs will be unable to use.").defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"blockedStandActions"}), () -> Arrays.asList("rotp_harvest:search", "rotp_harvest:go_to_this_place", "rotp_harvest:set_target", "rotp_harvest:forget_target", "rotp_zbc:set_target", "rotp_zbc:forget_target", "rotp_harvest:stay_with", "rotp_harvest:carry_up"), obj -> obj instanceof String);
            this.longRangeStands = builder.translation("rotp_mwp.config.long_range_stands").comment("    A list of long-range Stands. Increases their operational range to 32 blocks for mobs.").defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"longRangeStands"}), () -> Arrays.asList("rotp_harvest:harvest_stand", "rotp_zbc:bad_company", "rotp_zgd:green_day"), obj -> obj instanceof String);
            this.useAddonStands = builder.translation("rotp.mwp.config.use_addon_stands").comment(new String[]{"    Allow mobs to get Stands from other addons.", "    WARNING: THIS MAY CAUSE ISSUES AND CRASHES! Please send reports to the addon's Discord thread."}).define("useAddonStands", false);
            this.smallAnarchyWithStands = builder.translation("rotp.mwp.config.smallanarchywithstands").comment("    Allows giving a Stand to a Stand. May lead to chaos and lag.").define("smallAnarchyWithStands", false);
            this.dropStandDiscFromMobs = builder.translation("rotp.mwp.config.drop_stand_disc_from_mobs").comment(new String[]{"    If enabled, Stand-user mobs will drop a disc of their Stand upon death.", "    - Only works if 'keepStandOnDeath' in the 'jojo-common' config is set to 'false'."}).define("dropStandDiscFromMobs", false);
            this.spawnBoy2Man = builder.translation("rotp.mwp.config.spawnboy2man").comment(new String[]{"    Allows Boy II Man to spawn in villages.", "    - WARNING: This entity is a Work-In-Progress and may have bugs!"}).define("spawnBoy2Man", false);
            this.useWIPComboSystem = builder.translation("rotp.mwp.config.usewipcombosystem").comment(new String[]{"    Use the advanced combo system for mobs.", "    - If disabled, mobs will use random abilities without any logic."}).define("useWIPComboSystem", true);
            this.requireStandAdvancementToSpawnMobsWithPowers = builder.translation("rotp.mwp.config.requirestandadvancementtospawnmobswithpowers").comment("    If enabled, mobs will only get a Stand if at least one player on the server has the specified advancement.").define("requireStandAdvancementToSpawnMobsWithPowers", true);
            builder.pop();
            if (mainPath != null) {
                builder.pop();
            }
        }

        public boolean isConfigLoaded() {
            return this.loaded;
        }

        private void onLoadOrReload() {
            this.loaded = true;
        }

        public static class SyncedValues {
            private final int percentageChanceToGettingAStandForMob;
            private final boolean useEntityWhitelist;
            private final List<String> entityList;
            private final List<String> blockedStandsForMobs;
            private final List<String> blockedStandActionsForMobs;
            private final List<String> longRangeStands;
            private final boolean useAddonStands;
            private final boolean smallAnarchyWithStands;
            private final boolean dropStandDiscFromMobs;
            private final boolean spawnBoy2Man;
            private final boolean useWIPComboSystem;
            private final boolean requireStandAdvancementToSpawnMobs;

            public SyncedValues(PacketBuffer buf) {
                this.percentageChanceToGettingAStandForMob = buf.readInt();
                this.useEntityWhitelist = buf.readBoolean();
                int entityListSize = buf.readInt();
                this.entityList = new ArrayList<String>(entityListSize);
                for (int i = 0; i < entityListSize; ++i) {
                    this.entityList.add(buf.func_218666_n());
                }
                int blockedStandsForMobsSize = buf.readInt();
                this.blockedStandsForMobs = new ArrayList<String>(blockedStandsForMobsSize);
                for (int i = 0; i < blockedStandsForMobsSize; ++i) {
                    this.blockedStandsForMobs.add(buf.func_218666_n());
                }
                int blockedStandActionsForMobsSize = buf.readInt();
                this.blockedStandActionsForMobs = new ArrayList<String>(blockedStandActionsForMobsSize);
                for (int i = 0; i < blockedStandActionsForMobsSize; ++i) {
                    this.blockedStandActionsForMobs.add(buf.func_218666_n());
                }
                int longRangeStandsSize = buf.readInt();
                this.longRangeStands = new ArrayList<String>(longRangeStandsSize);
                for (int i = 0; i < longRangeStandsSize; ++i) {
                    this.longRangeStands.add(buf.func_218666_n());
                }
                this.useAddonStands = buf.readBoolean();
                this.smallAnarchyWithStands = buf.readBoolean();
                this.dropStandDiscFromMobs = buf.readBoolean();
                this.spawnBoy2Man = buf.readBoolean();
                this.useWIPComboSystem = buf.readBoolean();
                this.requireStandAdvancementToSpawnMobs = buf.readBoolean();
            }

            private SyncedValues(Common config) {
                this.percentageChanceToGettingAStandForMob = (Integer)config.percentageChanceToGettingAStandForMob.get();
                this.useEntityWhitelist = (Boolean)config.useEntityWhitelist.get();
                this.entityList = (List)config.entityList.get();
                this.blockedStandsForMobs = (List)config.blockedStandsForMobs.get();
                this.blockedStandActionsForMobs = (List)config.blockedStandActionsForMobs.get();
                this.longRangeStands = (List)config.longRangeStands.get();
                this.useAddonStands = (Boolean)config.useAddonStands.get();
                this.smallAnarchyWithStands = (Boolean)config.smallAnarchyWithStands.get();
                this.dropStandDiscFromMobs = (Boolean)config.dropStandDiscFromMobs.get();
                this.spawnBoy2Man = (Boolean)config.spawnBoy2Man.get();
                this.useWIPComboSystem = (Boolean)config.useWIPComboSystem.get();
                this.requireStandAdvancementToSpawnMobs = (Boolean)config.requireStandAdvancementToSpawnMobsWithPowers.get();
            }

            public static void resetConfig() {
                COMMON_SYNCED_TO_CLIENT.percentageChanceToGettingAStandForMob.clearCache();
                COMMON_SYNCED_TO_CLIENT.useEntityWhitelist.clearCache();
                COMMON_SYNCED_TO_CLIENT.entityList.clearCache();
                COMMON_SYNCED_TO_CLIENT.blockedStandsForMobs.clearCache();
                COMMON_SYNCED_TO_CLIENT.blockedStandActionsForMobs.clearCache();
                COMMON_SYNCED_TO_CLIENT.longRangeStands.clearCache();
                COMMON_SYNCED_TO_CLIENT.useAddonStands.clearCache();
                COMMON_SYNCED_TO_CLIENT.smallAnarchyWithStands.clearCache();
                COMMON_SYNCED_TO_CLIENT.dropStandDiscFromMobs.clearCache();
                COMMON_SYNCED_TO_CLIENT.spawnBoy2Man.clearCache();
                COMMON_SYNCED_TO_CLIENT.useWIPComboSystem.clearCache();
                COMMON_SYNCED_TO_CLIENT.requireStandAdvancementToSpawnMobsWithPowers.clearCache();
            }

            public static void syncWithClient(ServerPlayerEntity player) {
                AddonPackets.sendToClient((Object)new CommonConfigPacket(new SyncedValues(COMMON_FROM_FILE)), player);
            }

            public static void onPlayerLogout(ServerPlayerEntity player) {
                AddonPackets.sendToClient((Object)new ResetSyncedCommonConfigPacket(), player);
            }

            public void writeToBuf(PacketBuffer buf) {
                buf.writeInt(this.percentageChanceToGettingAStandForMob);
                buf.writeBoolean(this.useEntityWhitelist);
                buf.writeInt(this.entityList.size());
                for (String entity : this.entityList) {
                    buf.func_180714_a(entity);
                }
                buf.writeInt(this.blockedStandsForMobs.size());
                for (String entity : this.blockedStandsForMobs) {
                    buf.func_180714_a(entity);
                }
                buf.writeInt(this.blockedStandActionsForMobs.size());
                for (String entity : this.blockedStandActionsForMobs) {
                    buf.func_180714_a(entity);
                }
                buf.writeInt(this.longRangeStands.size());
                for (String entity : this.longRangeStands) {
                    buf.func_180714_a(entity);
                }
                buf.writeBoolean(this.useAddonStands);
                buf.writeBoolean(this.smallAnarchyWithStands);
                buf.writeBoolean(this.dropStandDiscFromMobs);
                buf.writeBoolean(this.spawnBoy2Man);
                buf.writeBoolean(this.useWIPComboSystem);
                buf.writeBoolean(this.requireStandAdvancementToSpawnMobs);
            }

            public void changeConfigValues() {
                COMMON_SYNCED_TO_CLIENT.percentageChanceToGettingAStandForMob.set((Object)this.percentageChanceToGettingAStandForMob);
                COMMON_SYNCED_TO_CLIENT.useEntityWhitelist.set((Object)this.useEntityWhitelist);
                COMMON_SYNCED_TO_CLIENT.entityList.set(this.entityList);
                COMMON_SYNCED_TO_CLIENT.blockedStandsForMobs.set(this.blockedStandsForMobs);
                COMMON_SYNCED_TO_CLIENT.blockedStandActionsForMobs.set(this.blockedStandActionsForMobs);
                COMMON_SYNCED_TO_CLIENT.longRangeStands.set(this.longRangeStands);
                COMMON_SYNCED_TO_CLIENT.useAddonStands.set((Object)this.useAddonStands);
                COMMON_SYNCED_TO_CLIENT.smallAnarchyWithStands.set((Object)this.smallAnarchyWithStands);
                COMMON_SYNCED_TO_CLIENT.dropStandDiscFromMobs.set((Object)this.dropStandDiscFromMobs);
                COMMON_SYNCED_TO_CLIENT.spawnBoy2Man.set((Object)this.spawnBoy2Man);
                COMMON_SYNCED_TO_CLIENT.useWIPComboSystem.set((Object)this.useWIPComboSystem);
                COMMON_SYNCED_TO_CLIENT.requireStandAdvancementToSpawnMobsWithPowers.set((Object)this.requireStandAdvancementToSpawnMobs);
            }
        }
    }
}

