/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.actions;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.ActionConditionResult;
import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.init.ModItems;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.impl.nonstand.INonStandPower;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;
import net.weever.rotp_mwp.util.AddonUtil;
import net.weever.rotp_mwp.util.RainbowTextUtil;
import net.weever.rotp_mwp.util.TextureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GiveRandomPower
extends StandAction {
    public GiveRandomPower(StandAction.Builder builder) {
        super((StandAction.AbstractBuilder)builder);
    }

    public ActionConditionResult checkRangeAndTarget(ActionTarget target, LivingEntity user, IStandPower power) {
        super.checkRangeAndTarget(target, user, (IPower)power);
        Entity entity = target.getEntity();
        if (entity instanceof LivingEntity) {
            boolean hasPower = INonStandPower.getNonStandPowerOptional((LivingEntity)((LivingEntity)entity)).map(mobPower -> mobPower.getType() != null).orElse(false);
            return hasPower ? ActionConditionResult.NEGATIVE : ActionConditionResult.POSITIVE;
        }
        return ActionConditionResult.NEGATIVE;
    }

    protected void perform(World world, LivingEntity user, IStandPower power, ActionTarget target) {
        if (!world.func_201670_d() && target.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target.getEntity();
            Random random = new Random();
            INonStandPower.getNonStandPowerOptional((LivingEntity)livingEntity).ifPresent(mobPower -> mobPower.givePower(AddonUtil.randomPower(livingEntity, random)));
        }
    }

    public IFormattableTextComponent getTranslatedName(IStandPower power, String key) {
        return RainbowTextUtil.getRainbowText("Give Random Power", false);
    }

    public Action.TargetRequirement getTargetRequirement() {
        return Action.TargetRequirement.ENTITY;
    }

    @NotNull
    public ResourceLocation getIconTexture(@Nullable IStandPower power) {
        ResourceLocation randomizedTexture = TextureUtil.getResourceLocation((Item)ModItems.HAMON_MASTER_SPAWN_EGG.get());
        if (randomizedTexture != null) {
            return randomizedTexture;
        }
        return super.getIconTexture(power);
    }
}

