/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.actions;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.ActionConditionResult;
import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.init.ModItems;
import com.github.standobyte.jojo.item.StandDiscItem;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.IPowerType;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import com.github.standobyte.jojo.power.impl.stand.StandInstance;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;
import net.weever.rotp_mwp.util.AddonUtil;
import net.weever.rotp_mwp.util.RainbowTextUtil;
import net.weever.rotp_mwp.util.TextureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GiveRandomStand
extends StandAction {
    @Nullable
    private StandInstance standInstanceFromDisc;

    public GiveRandomStand(StandAction.Builder builder) {
        super((StandAction.AbstractBuilder)builder);
    }

    public ActionConditionResult checkRangeAndTarget(ActionTarget target, LivingEntity user, IStandPower power) {
        super.checkRangeAndTarget(target, user, (IPower)power);
        Entity entity = target.getEntity();
        if (entity instanceof LivingEntity) {
            ItemStack mainHandItem = user.func_184614_ca();
            ItemStack offHandItem = user.func_184592_cb();
            this.standInstanceFromDisc = mainHandItem.func_77973_b() instanceof StandDiscItem ? StandDiscItem.getStandFromStack((ItemStack)mainHandItem) : (offHandItem.func_77973_b() instanceof StandDiscItem ? StandDiscItem.getStandFromStack((ItemStack)offHandItem) : null);
            boolean hasStandPower = IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)entity)).map(mobPower -> mobPower.getType() != null).orElse(false);
            return hasStandPower ? ActionConditionResult.NEGATIVE : ActionConditionResult.POSITIVE;
        }
        return ActionConditionResult.NEGATIVE;
    }

    protected void perform(World world, LivingEntity user, IStandPower power, ActionTarget target) {
        if (!world.func_201670_d() && target.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target.getEntity();
            Random random = new Random();
            IStandPower.getStandPowerOptional((LivingEntity)livingEntity).ifPresent(standPower -> {
                if (this.standInstanceFromDisc != null) {
                    standPower.givePower((IPowerType)this.standInstanceFromDisc.getType());
                } else {
                    standPower.givePower(AddonUtil.randomStand(livingEntity, random));
                }
                standPower.setResolveLevel(4);
            });
        }
    }

    public IFormattableTextComponent getTranslatedName(IStandPower power, String key) {
        if (this.standInstanceFromDisc != null) {
            return RainbowTextUtil.getRainbowText("Give [" + this.standInstanceFromDisc.getName().getString() + "] Stand", false);
        }
        return RainbowTextUtil.getRainbowText("Give Random Stand", false);
    }

    public Action.TargetRequirement getTargetRequirement() {
        return Action.TargetRequirement.ENTITY;
    }

    @NotNull
    public ResourceLocation getIconTexture(@Nullable IStandPower power) {
        ResourceLocation randomizedTexture = TextureUtil.getResourceLocation((Item)ModItems.STAND_ARROW.get());
        if (randomizedTexture != null) {
            return randomizedTexture;
        }
        return super.getIconTexture(power);
    }
}

