/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.actions;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.ActionConditionResult;
import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.init.ModItems;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;
import net.weever.rotp_mwp.util.RainbowTextUtil;
import net.weever.rotp_mwp.util.TextureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveStand
extends StandAction {
    public RemoveStand(StandAction.Builder builder) {
        super((StandAction.AbstractBuilder)builder);
    }

    public ActionConditionResult checkTarget(ActionTarget target, LivingEntity user, IStandPower power) {
        Entity targetEntity = target.getEntity();
        if (targetEntity instanceof LivingEntity && IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)targetEntity)).map(mobPower -> mobPower.getType() != null).orElse(false).booleanValue()) {
            return ActionConditionResult.POSITIVE;
        }
        return ActionConditionResult.NEGATIVE;
    }

    protected void perform(World world, LivingEntity user, IStandPower power, ActionTarget target) {
        if (!world.func_201670_d() && target.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target.getEntity();
            IStandPower.getStandPowerOptional((LivingEntity)livingEntity).ifPresent(standPower -> {
                standPower.clear();
                standPower.fullStandClear();
            });
        }
    }

    public IFormattableTextComponent getTranslatedName(IStandPower power, String key) {
        return RainbowTextUtil.getRainbowText("Remove Stand", false);
    }

    public Action.TargetRequirement getTargetRequirement() {
        return Action.TargetRequirement.ENTITY;
    }

    @NotNull
    public ResourceLocation getIconTexture(@Nullable IStandPower power) {
        ResourceLocation randomizedTexture = TextureUtil.getResourceLocation((Item)ModItems.STAND_REMOVER.get());
        if (randomizedTexture != null) {
            return randomizedTexture;
        }
        return super.getIconTexture(power);
    }
}

