/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.actions;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.ActionConditionResult;
import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;
import net.weever.rotp_mwp.util.AddonUtil;
import net.weever.rotp_mwp.util.RainbowTextUtil;
import net.weever.rotp_mwp.util.TextureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseRandomAction
extends StandAction {
    public UseRandomAction(StandAction.Builder builder) {
        super((StandAction.AbstractBuilder)builder);
    }

    public ActionConditionResult checkRangeAndTarget(ActionTarget target, LivingEntity user, IStandPower power) {
        super.checkRangeAndTarget(target, user, (IPower)power);
        Entity targetEntity = target.getEntity();
        if (targetEntity instanceof LivingEntity && IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)targetEntity)).map(mobPower -> mobPower.getType() != null).orElse(false).booleanValue()) {
            return ActionConditionResult.POSITIVE;
        }
        return ActionConditionResult.NEGATIVE;
    }

    protected void perform(World world, LivingEntity user, IStandPower power, ActionTarget target) {
        if (!world.func_201670_d() && target.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target.getEntity();
            IStandPower.getStandPowerOptional((LivingEntity)livingEntity).ifPresent(standPower -> {
                StandAction randomAction;
                List<StandAction> actions = AddonUtil.getListOfUnlockedStandActions(standPower);
                Random random = new Random();
                if (!actions.isEmpty() && (randomAction = actions.get(random.nextInt(actions.size()))).getStaminaCost(standPower) <= standPower.getStamina()) {
                    if (randomAction.getHoldDurationToFire((IPower)standPower) > 0) {
                        standPower.setHeldAction((Action)randomAction, AddonUtil.getActionTarget(livingEntity));
                    } else {
                        standPower.clickAction((Action)randomAction, false, AddonUtil.getActionTarget(livingEntity), null);
                    }
                }
            });
        }
    }

    public IFormattableTextComponent getTranslatedName(IStandPower power, String key) {
        return RainbowTextUtil.getRainbowText("Use Random Action", false);
    }

    public Action.TargetRequirement getTargetRequirement() {
        return Action.TargetRequirement.ENTITY;
    }

    @NotNull
    public ResourceLocation getIconTexture(@Nullable IStandPower power) {
        ResourceLocation randomizedTexture = TextureUtil.getRandomActionTexture();
        if (randomizedTexture != null) {
            return randomizedTexture;
        }
        return super.getIconTexture(power);
    }
}

