/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.util;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.init.power.JojoCustomRegistries;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TextureUtil {
    @Nullable
    public static ResourceLocation getResourceLocation(@Nullable String modid, String folder, String name) {
        if (modid == null) {
            modid = "minecraft";
        }
        return new ResourceLocation(modid, "textures/" + folder + "/" + name + ".png");
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Item item) {
        if (item != null && item.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(item.getRegistryName().func_110624_b(), "item", item.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Effect effect) {
        if (effect != null && effect.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(effect.getRegistryName().func_110624_b(), "mob_effect", effect.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Block block) {
        if (block != null && block.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(block.getRegistryName().func_110624_b(), "block", block.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(ParticleType particle) {
        if (particle != null && particle.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(particle.getRegistryName().func_110624_b(), "particle", particle.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Action action) {
        if (action != null && action.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(action.getRegistryName().func_110624_b(), "action", action.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(StandType standType) {
        if (standType != null && standType.getRegistryName() != null) {
            return TextureUtil.getResourceLocation(standType.getRegistryName().func_110624_b(), "power", standType.getRegistryName().func_110623_a());
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getRandomActionTexture() {
        List STAND_ACTIONS = Arrays.stream(JojoCustomRegistries.ACTIONS.getRegistry().getValues().toArray(new Action[0])).filter(action -> action instanceof StandAction).map(action -> (StandAction)action).collect(Collectors.toList());
        long millis = System.currentTimeMillis();
        int index = (int)(millis / 1000L % (long)STAND_ACTIONS.size());
        return TextureUtil.getResourceLocation((Action)STAND_ACTIONS.get(index));
    }

    @Nullable
    public static ResourceLocation getRandomStandTexture() {
        StandType[] STANDS = (StandType[])JojoCustomRegistries.STANDS.getRegistry().getValues().stream().toArray(StandType[]::new);
        long millis = System.currentTimeMillis();
        int index = (int)(millis / 1000L % (long)STANDS.length);
        return TextureUtil.getResourceLocation(STANDS[index]);
    }
}

