/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.actions;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.ActionConditionResult;
import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.init.ModParticles;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;
import net.weever.rotp_mwp.util.RainbowTextUtil;
import net.weever.rotp_mwp.util.TextureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleSummon
extends StandAction {
    @Nullable
    private StandType targetStandType;

    public ToggleSummon(StandAction.Builder builder) {
        super((StandAction.AbstractBuilder)builder);
    }

    public ActionConditionResult checkRangeAndTarget(ActionTarget target, LivingEntity user, IStandPower power) {
        super.checkRangeAndTarget(target, user, (IPower)power);
        Entity targetEntity = target.getEntity();
        if (targetEntity instanceof LivingEntity) {
            if (IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)targetEntity)).map(mobPower -> mobPower.getType() != null).orElse(false).booleanValue()) {
                this.targetStandType = IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)targetEntity)).map(IPower::getType).orElse(null);
                return ActionConditionResult.POSITIVE;
            }
            this.targetStandType = null;
            return ActionConditionResult.NEGATIVE;
        }
        this.targetStandType = null;
        return ActionConditionResult.NEGATIVE;
    }

    protected void perform(World world, LivingEntity user, IStandPower power, ActionTarget target) {
        if (!world.func_201670_d() && target.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target.getEntity();
            IStandPower.getStandPowerOptional((LivingEntity)livingEntity).ifPresent(IStandPower::toggleSummon);
        }
    }

    public IFormattableTextComponent getTranslatedName(IStandPower power, String key) {
        return RainbowTextUtil.getRainbowText("Toggle Summon", false);
    }

    public Action.TargetRequirement getTargetRequirement() {
        return Action.TargetRequirement.ENTITY;
    }

    @NotNull
    public ResourceLocation getIconTexture(@Nullable IStandPower power) {
        if (this.targetStandType != null) {
            ResourceLocation standTypeTexture = TextureUtil.getResourceLocation(this.targetStandType);
            if (standTypeTexture != null) {
                return standTypeTexture;
            }
        } else {
            ResourceLocation randomizedTexture = TextureUtil.getResourceLocation((ParticleType)ModParticles.METEORITE_VIRUS.get());
            if (randomizedTexture != null) {
                return randomizedTexture;
            }
        }
        return super.getIconTexture(power);
    }
}

