/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.entity.goal;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.init.power.non_stand.ModPowers;
import com.github.standobyte.jojo.init.power.non_stand.hamon.ModHamonActions;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.impl.nonstand.INonStandPower;
import com.github.standobyte.jojo.power.impl.nonstand.type.NonStandPowerType;
import com.github.standobyte.jojo.power.impl.nonstand.type.hamon.HamonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.weever.rotp_mwp.mechanics.combo.ComboManager;
import net.weever.rotp_mwp.mechanics.combo.ComboStep;
import net.weever.rotp_mwp.mechanics.combo.MaintenanceStep;
import net.weever.rotp_mwp.mechanics.combo.NonStandComboData;
import net.weever.rotp_mwp.util.AddonUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NonStandAI
extends Goal {
    private final MobEntity mobEntity;
    private final Map<String, Integer> cooldownMap = new HashMap<String, Integer>();
    private final Random random = new Random();
    private int actionChangeTicks = 0;
    private String currentComboName = null;
    private int comboStep = 0;
    private int comboResetTicks = 0;
    private static final int MAX_COMBO_TICK_DELAY = 60;
    private static final Logger LOGGER = LogManager.getLogger();

    public NonStandAI(MobEntity mobEntity) {
        this.mobEntity = mobEntity;
    }

    public boolean func_75250_a() {
        return INonStandPower.getNonStandPowerOptional((LivingEntity)this.mobEntity).map(power -> power.getType() != null).orElse(false) != false && this.mobEntity.func_70089_S();
    }

    public void func_75246_d() {
        this.updateCooldowns();
        INonStandPower.getNonStandPowerOptional((LivingEntity)this.mobEntity).ifPresent(this::runAI);
    }

    private void runAI(INonStandPower power) {
        if (power == null || power.getType() == null) {
            return;
        }
        power.tick();
        power.postTick();
        if (this.comboResetTicks > 0) {
            --this.comboResetTicks;
        } else {
            this.resetCombo();
        }
        LivingEntity target = this.mobEntity.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            if (power.getHeldAction(true) != null) {
                power.stopHeldAction(true);
            }
            this.resetCombo();
            return;
        }
        ++this.actionChangeTicks;
        if (this.actionChangeTicks % 20 != 0) {
            return;
        }
        power.refreshHeldActionTickState(true);
        Map<String, Action<INonStandPower>> allActions = ((NonStandPowerType)power.getType()).getUnlockedDefaultActions(power).stream().collect(Collectors.toMap(a -> a.getRegistryName().toString(), a -> a, (a1, a2) -> a1));
        if (allActions.isEmpty()) {
            return;
        }
        String powerId = ((NonStandPowerType)power.getType()).getRegistryName().toString();
        NonStandComboData comboData = ComboManager.getDataForNonStand(powerId);
        if (comboData == null) {
            this.performRandomAvailableAction(power, allActions, target);
        } else {
            if (this.tryPerformMaintenance(power, comboData, allActions, target)) {
                return;
            }
            this.performComboLogic(power, comboData, allActions, target);
        }
    }

    private boolean tryPerformMaintenance(INonStandPower power, NonStandComboData data, Map<String, Action<INonStandPower>> allActions, LivingEntity target) {
        Action<INonStandPower> action;
        MaintenanceStep maintenance = data.getMaintenance();
        if (maintenance == null || maintenance.getAction() == null || maintenance.getCondition() == null) {
            return false;
        }
        boolean conditionMet = this.checkMaintenanceCondition(power, maintenance.getCondition());
        if (conditionMet && this.isActionAvailable(power, action = allActions.get(maintenance.getAction()), null, this.mobEntity.func_70032_d((Entity)target))) {
            this.performAction(power, action);
            return true;
        }
        return false;
    }

    private boolean checkMaintenanceCondition(INonStandPower power, String condition) {
        try {
            float max;
            float current;
            String[] parts = condition.replace(" ", "").split("<|>");
            String resourceType = parts[0];
            double percentage = Double.parseDouble(parts[1].replace("%", ""));
            if (resourceType.equalsIgnoreCase("energy")) {
                Optional hamonOp = power.getTypeSpecificData((NonStandPowerType)ModPowers.HAMON.get());
                if (!hamonOp.isPresent()) {
                    return false;
                }
                HamonData hamon = (HamonData)hamonOp.get();
                current = hamon.getEnergyRatio();
                max = hamon.getMaxEnergy();
            } else if (resourceType.equalsIgnoreCase("blood")) {
                current = power.getEnergy();
                max = power.getMaxEnergy();
            } else {
                return false;
            }
            double currentPercentage = (double)(current / max) * 100.0;
            return condition.contains("<") ? currentPercentage < percentage : currentPercentage > percentage;
        }
        catch (Exception e) {
            LOGGER.warn("Invalid maintenance condition format in non-stand combo JSON: " + condition, (Throwable)e);
            return false;
        }
    }

    private void performComboLogic(INonStandPower power, NonStandComboData comboData, Map<String, Action<INonStandPower>> allActions, LivingEntity target) {
        if (this.currentComboName != null) {
            this.tryToContinueCombo(power, comboData, allActions, target);
        } else {
            this.tryToStartNewCombo(power, comboData, allActions, target);
        }
    }

    private void tryToContinueCombo(INonStandPower power, NonStandComboData comboData, Map<String, Action<INonStandPower>> allActions, LivingEntity target) {
        List<ComboStep> currentStepList = comboData.getComboSteps(this.currentComboName);
        if (currentStepList == null || this.comboStep >= currentStepList.size()) {
            this.resetCombo();
            return;
        }
        ComboStep nextStep = currentStepList.get(this.comboStep);
        Action<INonStandPower> action = allActions.get(nextStep.getAction());
        if (this.isActionAvailable(power, action, nextStep, this.mobEntity.func_70032_d((Entity)target))) {
            this.performAction(power, action);
            ++this.comboStep;
            this.comboResetTicks = 60;
        } else {
            this.resetCombo();
        }
    }

    private void tryToStartNewCombo(INonStandPower power, NonStandComboData comboData, Map<String, Action<INonStandPower>> allActions, LivingEntity target) {
        ArrayList<String> availableComboNames = new ArrayList<String>(comboData.getComboNames());
        Collections.shuffle(availableComboNames);
        for (String comboName : availableComboNames) {
            ComboStep firstStep;
            Action<INonStandPower> firstAction;
            List<ComboStep> stepList = comboData.getComboSteps(comboName);
            if (stepList == null || stepList.isEmpty() || !this.isActionAvailable(power, firstAction = allActions.get((firstStep = stepList.get(0)).getAction()), firstStep, this.mobEntity.func_70032_d((Entity)target))) continue;
            this.currentComboName = comboName;
            this.comboStep = 0;
            this.tryToContinueCombo(power, comboData, allActions, target);
            return;
        }
        this.performRandomAvailableAction(power, allActions, target);
    }

    private void performRandomAvailableAction(INonStandPower power, Map<String, Action<INonStandPower>> allActions, LivingEntity target) {
        List availableActions = allActions.values().stream().filter(action -> this.isActionAvailable(power, (Action<INonStandPower>)action, null, this.mobEntity.func_70032_d((Entity)target))).collect(Collectors.toList());
        if (!availableActions.isEmpty()) {
            Action randomAction = (Action)availableActions.get(this.random.nextInt(availableActions.size()));
            this.performAction(power, (Action<INonStandPower>)randomAction);
        }
    }

    private void performAction(INonStandPower power, Action<INonStandPower> action) {
        if (action.getHoldDurationToFire((IPower)power) > 0) {
            power.setHeldAction(action, AddonUtil.getActionTarget((LivingEntity)this.mobEntity));
        } else {
            power.clickAction(action, false, AddonUtil.getActionTarget((LivingEntity)this.mobEntity), null);
        }
        this.setCooldown(action.getRegistryName().toString(), action.getCooldownTechnical((IPower)power));
    }

    private boolean isActionAvailable(INonStandPower power, Action<INonStandPower> action, ComboStep step, double distanceToTarget) {
        boolean isAvailable;
        if (action == null) {
            return false;
        }
        boolean bl = isAvailable = !this.isOnCooldown(action.getRegistryName().toString()) && action.checkConditions((LivingEntity)this.mobEntity, (IPower)power, AddonUtil.getActionTarget((LivingEntity)this.mobEntity)).isPositive();
        if (!isAvailable) {
            return false;
        }
        if (step != null) {
            if (step.getRequiredStamina() != null && power.getType() == ModHamonActions.HAMON.get() && power.getEnergy() < (float)step.getRequiredStamina().intValue()) {
                return false;
            }
            if (step.getDistance() != null && !this.checkDistance(step.getDistance(), distanceToTarget)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkDistance(String condition, double actualDistance) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        try {
            if (condition.startsWith(">=")) {
                return actualDistance >= Double.parseDouble(condition.substring(2));
            }
            if (condition.startsWith("<=")) {
                return actualDistance <= Double.parseDouble(condition.substring(2));
            }
            if (condition.startsWith(">")) {
                return actualDistance > Double.parseDouble(condition.substring(1));
            }
            if (condition.startsWith("<")) {
                return actualDistance < Double.parseDouble(condition.substring(1));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid distance format: " + condition);
            return false;
        }
        return true;
    }

    private void resetCombo() {
        this.currentComboName = null;
        this.comboStep = 0;
        this.comboResetTicks = 0;
    }

    private boolean isOnCooldown(String actionId) {
        return this.cooldownMap.getOrDefault(actionId, 0) > 0;
    }

    private void setCooldown(String actionId, int cooldownTicks) {
        this.cooldownMap.put(actionId, cooldownTicks + 10);
    }

    private void updateCooldowns() {
        this.cooldownMap.forEach((id, cd) -> {
            if (cd > 0) {
                this.cooldownMap.put((String)id, cd - 1);
            }
        });
    }

    public boolean func_75253_b() {
        return this.mobEntity.func_70638_az() != null && this.mobEntity.func_70089_S();
    }

    public void func_75251_c() {
        this.resetCombo();
    }

    public void func_75249_e() {
    }
}

