/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.entity.goal;

import com.github.standobyte.jojo.action.Action;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.power.IPower;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.weever.rotp_mwp.Config;
import net.weever.rotp_mwp.MobsWithPowersAddon;
import net.weever.rotp_mwp.mechanics.combo.ComboManager;
import net.weever.rotp_mwp.mechanics.combo.ComboStep;
import net.weever.rotp_mwp.mechanics.combo.StandComboData;
import net.weever.rotp_mwp.util.AddonUtil;
import net.weever.rotp_mwp.util.CapabilityAdderForAll;

public class StandAI
extends Goal {
    private final MobEntity mobEntity;
    private final Map<String, Integer> cooldownMap = new HashMap<String, Integer>();
    private final Random random = new Random();
    private int actionChangeTicks = 0;
    private String currentComboName = null;
    private int comboStep = 0;
    private int comboResetTicks = 0;
    private static final int MAX_COMBO_TICK_DELAY = 60;

    public StandAI(MobEntity mobEntity) {
        this.mobEntity = mobEntity;
    }

    public boolean func_75250_a() {
        return IStandPower.getStandPowerOptional((LivingEntity)this.mobEntity).map(power -> power.getType() != null).orElse(false) != false && this.mobEntity.func_70089_S();
    }

    public void func_75246_d() {
        this.updateCooldowns();
        IStandPower.getStandPowerOptional((LivingEntity)this.mobEntity).ifPresent(this::runAI);
    }

    private void runAI(IStandPower power) {
        Map<String, StandAction> allActions;
        power.tick();
        power.postTick();
        if (this.comboResetTicks > 0) {
            --this.comboResetTicks;
        } else {
            this.resetCombo();
        }
        LivingEntity target = this.mobEntity.func_70638_az();
        if (target == null || !target.func_70089_S() || this.mobEntity.func_70068_e((Entity)target) > (double)(AddonUtil.getStandRange((StandType)power.getType(), this.mobEntity.field_70170_p) * AddonUtil.getStandRange((StandType)power.getType(), this.mobEntity.field_70170_p))) {
            if (power.getHeldAction(true) != null) {
                power.stopHeldAction(true);
            }
            if (power.isActive()) {
                power.toggleSummon();
            }
            this.resetCombo();
            return;
        }
        ++this.actionChangeTicks;
        if (this.actionChangeTicks % 20 != 0) {
            return;
        }
        power.refreshHeldActionTickState(true);
        if (!power.isActive()) {
            power.toggleSummon();
        }
        if ((allActions = AddonUtil.getListOfUnlockedStandActions(power).stream().collect(Collectors.toMap(a -> a.getRegistryName().toString(), a -> a, (a1, a2) -> a1))).isEmpty()) {
            return;
        }
        String standId = ((StandType)power.getType()).getRegistryName().toString();
        StandComboData comboData = ComboManager.getDataForStand(standId);
        if (comboData != null && comboData.getBlockAction() != null) {
            boolean shouldPreemptivelyBlock;
            String blockActionName = comboData.getBlockAction();
            StandAction blockAction = allActions.get(blockActionName);
            boolean wasRecentlyHurt = this.mobEntity.func_70643_av() != null && this.mobEntity.field_70173_aa - this.mobEntity.func_142015_aE() < 40;
            boolean bl = shouldPreemptivelyBlock = this.random.nextFloat() < 0.15f;
            if (blockAction != null && (wasRecentlyHurt || shouldPreemptivelyBlock) && this.isActionAvailable(power, blockAction, null, this.mobEntity.func_70032_d((Entity)target))) {
                this.performAction(power, blockAction);
                return;
            }
        }
        if (comboData == null || !((Boolean)Config.getCommonConfigInstance((boolean)this.mobEntity.field_70170_p.field_72995_K).useWIPComboSystem.get()).booleanValue()) {
            this.performRandomAvailableAction(power, allActions, target);
        } else {
            this.performComboLogic(power, comboData, allActions, target);
        }
    }

    private void performComboLogic(IStandPower power, StandComboData comboData, Map<String, StandAction> allActions, LivingEntity target) {
        if (this.currentComboName != null) {
            this.tryToContinueCombo(power, comboData, allActions, target);
        } else {
            this.tryToStartNewCombo(power, comboData, allActions, target);
        }
    }

    private void tryToContinueCombo(IStandPower power, StandComboData comboData, Map<String, StandAction> allActions, LivingEntity target) {
        List<ComboStep> currentStepList = comboData.getComboSteps(this.currentComboName);
        if (currentStepList == null || this.comboStep >= currentStepList.size()) {
            this.resetCombo();
            return;
        }
        ComboStep nextStep = currentStepList.get(this.comboStep);
        StandAction action = allActions.get(nextStep.getAction());
        if (this.isActionAvailable(power, action, nextStep, this.mobEntity.func_70032_d((Entity)target))) {
            this.performAction(power, action);
            ++this.comboStep;
            this.comboResetTicks = 60;
        } else {
            this.resetCombo();
        }
    }

    private void tryToStartNewCombo(IStandPower power, StandComboData comboData, Map<String, StandAction> allActions, LivingEntity target) {
        int resolve = power.getResolveLevel();
        List<String> availableComboNames = comboData.getAvailableCombos(resolve);
        if (availableComboNames.isEmpty()) {
            this.performRandomAvailableAction(power, allActions, target);
            return;
        }
        Collections.shuffle(availableComboNames);
        for (String comboName : availableComboNames) {
            ComboStep firstStep;
            StandAction firstAction;
            List<ComboStep> stepList = comboData.getComboSteps(comboName);
            if (stepList == null || stepList.isEmpty() || !this.isActionAvailable(power, firstAction = allActions.get((firstStep = stepList.get(0)).getAction()), firstStep, this.mobEntity.func_70032_d((Entity)target))) continue;
            this.currentComboName = comboName;
            this.comboStep = 0;
            this.tryToContinueCombo(power, comboData, allActions, target);
            return;
        }
        this.performRandomAvailableAction(power, allActions, target);
    }

    private void performRandomAvailableAction(IStandPower power, Map<String, StandAction> allActions, LivingEntity target) {
        List availableActions = allActions.values().stream().filter(action -> this.isActionAvailable(power, (StandAction)action, null, this.mobEntity.func_70032_d((Entity)target))).collect(Collectors.toList());
        if (!availableActions.isEmpty()) {
            StandAction randomAction = (StandAction)availableActions.get(this.random.nextInt(availableActions.size()));
            this.performAction(power, randomAction);
        }
    }

    private void performAction(IStandPower power, StandAction action) {
        if (action.getHoldDurationToFire((IPower)power) > 0) {
            power.setHeldAction((Action)action, AddonUtil.getActionTarget((LivingEntity)this.mobEntity));
        } else {
            power.clickAction((Action)action, false, AddonUtil.getActionTarget((LivingEntity)this.mobEntity), null);
        }
        this.setCooldown(action.getRegistryName().toString(), action.getCooldownTechnical((IPower)power));
    }

    private boolean isActionAvailable(IStandPower power, StandAction action, ComboStep step, double distanceToTarget) {
        boolean isAvailable;
        if (action == null) {
            return false;
        }
        boolean bl = isAvailable = !this.isOnCooldown(action.getRegistryName().toString()) && action.checkConditions((LivingEntity)this.mobEntity, power, AddonUtil.getActionTarget((LivingEntity)this.mobEntity)).isPositive() && action.getStaminaCost(power) <= power.getStamina() && !CapabilityAdderForAll.isBlockedAction(action, this.mobEntity.field_70170_p);
        if (!isAvailable) {
            return false;
        }
        if (step != null) {
            if (step.getRequiredStamina() != null && power.getStamina() < (float)step.getRequiredStamina().intValue()) {
                return false;
            }
            return step.getDistance() == null || this.checkDistance(step.getDistance(), distanceToTarget);
        }
        return true;
    }

    private boolean checkDistance(String condition, double actualDistance) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        try {
            if (condition.startsWith(">=")) {
                return actualDistance >= Double.parseDouble(condition.substring(2));
            }
            if (condition.startsWith("<=")) {
                return actualDistance <= Double.parseDouble(condition.substring(2));
            }
            if (condition.startsWith(">")) {
                return actualDistance > Double.parseDouble(condition.substring(1));
            }
            if (condition.startsWith("<")) {
                return actualDistance < Double.parseDouble(condition.substring(1));
            }
        }
        catch (NumberFormatException e) {
            MobsWithPowersAddon.getLogger().warn("Invalid distance format in combo JSON: {}", (Object)condition);
            return false;
        }
        return true;
    }

    private void resetCombo() {
        this.currentComboName = null;
        this.comboStep = 0;
        this.comboResetTicks = 0;
    }

    private boolean isOnCooldown(String actionId) {
        return this.cooldownMap.getOrDefault(actionId, 0) > 0;
    }

    private void setCooldown(String actionId, int cooldownTicks) {
        this.cooldownMap.put(actionId, cooldownTicks + 10);
    }

    private void updateCooldowns() {
        this.cooldownMap.forEach((action, cooldown) -> {
            if (cooldown > 0) {
                this.cooldownMap.put((String)action, cooldown - 1);
            }
        });
    }

    public boolean func_75253_b() {
        return this.mobEntity.func_70638_az() != null && this.mobEntity.func_70089_S();
    }

    public void func_75251_c() {
        this.resetCombo();
    }
}

