/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.mechanics.combo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.weever.rotp_mwp.MobsWithPowersAddon;
import net.weever.rotp_mwp.mechanics.combo.NonStandComboData;
import net.weever.rotp_mwp.mechanics.combo.StandComboData;
import org.jetbrains.annotations.NotNull;

public class ComboManager
implements ISelectiveResourceReloadListener {
    private static final String STAND_FOLDER_NAME = "stand_combos";
    private static final String NON_STAND_FOLDER_NAME = "nonstand_combos";
    private static final Gson STAND_GSON = new GsonBuilder().registerTypeAdapter(StandComboData.class, (Object)new StandComboData.Deserializer()).setPrettyPrinting().create();
    private static final Gson NON_STAND_GSON = new GsonBuilder().registerTypeAdapter(NonStandComboData.class, (Object)new NonStandComboData.Deserializer()).setPrettyPrinting().create();
    private static final Map<String, StandComboData> STAND_COMBOS = new HashMap<String, StandComboData>();
    private static final Map<String, NonStandComboData> NON_STAND_COMBOS = new HashMap<String, NonStandComboData>();

    public void onResourceManagerReload(IResourceManager resourceManager, @NotNull Predicate<IResourceType> resourcePredicate) {
        this.loadStandCombos(resourceManager);
        this.loadNonStandCombos(resourceManager);
    }

    private void loadStandCombos(IResourceManager resourceManager) {
        STAND_COMBOS.clear();
        Collection resources = resourceManager.func_199003_a(STAND_FOLDER_NAME, path -> path.endsWith(".json"));
        MobsWithPowersAddon.getLogger().info("Found {} stand combo files to load.", (Object)resources.size());
        for (ResourceLocation location : resources) {
            try {
                IResource resource = resourceManager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                    Throwable throwable2 = null;
                    try {
                        Type type = new TypeToken<Map<String, StandComboData>>(){}.getType();
                        Map loadedFile = (Map)STAND_GSON.fromJson((Reader)reader, type);
                        if (loadedFile == null) continue;
                        STAND_COMBOS.putAll(loadedFile);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (Exception e) {
                MobsWithPowersAddon.getLogger().error("Failed to load stand combo file: " + location, (Throwable)e);
            }
        }
        MobsWithPowersAddon.getLogger().info("Loaded a total of {} stand combo configurations.", (Object)STAND_COMBOS.size());
    }

    private void loadNonStandCombos(IResourceManager resourceManager) {
        NON_STAND_COMBOS.clear();
        Collection resources = resourceManager.func_199003_a(NON_STAND_FOLDER_NAME, path -> path.endsWith(".json"));
        MobsWithPowersAddon.getLogger().info("Found {} non-stand combo files to load.", (Object)resources.size());
        for (ResourceLocation location : resources) {
            try {
                IResource resource = resourceManager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                    Throwable throwable2 = null;
                    try {
                        Type type = new TypeToken<Map<String, NonStandComboData>>(){}.getType();
                        Map loadedFile = (Map)NON_STAND_GSON.fromJson((Reader)reader, type);
                        if (loadedFile == null) continue;
                        NON_STAND_COMBOS.putAll(loadedFile);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (Exception e) {
                MobsWithPowersAddon.getLogger().error("Failed to load non-stand combo file: " + location, (Throwable)e);
            }
        }
        MobsWithPowersAddon.getLogger().info("Loaded a total of {} non-stand combo configurations.", (Object)NON_STAND_COMBOS.size());
    }

    public static StandComboData getDataForStand(String standId) {
        return STAND_COMBOS.get(standId);
    }

    public static NonStandComboData getDataForNonStand(String powerId) {
        return NON_STAND_COMBOS.get(powerId);
    }
}

