/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.mechanics.combo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.weever.rotp_mwp.mechanics.combo.ComboStep;
import net.weever.rotp_mwp.mechanics.combo.MaintenanceStep;

public class NonStandComboData {
    private final Map<String, List<ComboStep>> combos = new HashMap<String, List<ComboStep>>();
    private MaintenanceStep maintenance;

    public List<ComboStep> getComboSteps(String comboName) {
        return this.combos.get(comboName);
    }

    public MaintenanceStep getMaintenance() {
        return this.maintenance;
    }

    public Set<String> getComboNames() {
        return this.combos.keySet();
    }

    public static class Deserializer
    implements JsonDeserializer<NonStandComboData> {
        public NonStandComboData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            NonStandComboData data = new NonStandComboData();
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (key.equals("maintenance")) {
                    data.maintenance = (MaintenanceStep)context.deserialize(value, MaintenanceStep.class);
                    continue;
                }
                List stepList = (List)context.deserialize(value, new TypeToken<List<ComboStep>>(){}.getType());
                data.combos.put(key, stepList);
            }
            return data;
        }
    }
}

