/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.mechanics.combo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.weever.rotp_mwp.mechanics.combo.ComboStep;

public class StandComboData {
    private final Map<String, List<ComboStep>> combos = new HashMap<String, List<ComboStep>>();
    private String blockAction;
    private Map<String, List<String>> useByResolve;

    public List<ComboStep> getComboSteps(String comboName) {
        return this.combos.get(comboName);
    }

    public String getBlockAction() {
        return this.blockAction;
    }

    public List<String> getAvailableCombos(int resolveLevel) {
        if (this.useByResolve == null || this.useByResolve.isEmpty()) {
            return new ArrayList<String>(this.combos.keySet());
        }
        return this.useByResolve.getOrDefault(resolveLevel + "lvl", new ArrayList());
    }

    public static class Deserializer
    implements JsonDeserializer<StandComboData> {
        public StandComboData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            StandComboData data = new StandComboData();
            JsonObject jsonObject = json.getAsJsonObject();
            block8: for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                switch (key) {
                    case "block": {
                        data.blockAction = value.getAsString();
                        continue block8;
                    }
                    case "use_by_resolve": {
                        data.useByResolve = (Map)context.deserialize(value, new TypeToken<Map<String, List<String>>>(){}.getType());
                        continue block8;
                    }
                }
                List stepList = (List)context.deserialize(value, new TypeToken<List<ComboStep>>(){}.getType());
                data.combos.put(key, stepList);
            }
            return data;
        }
    }
}

