/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.mixins;

import com.github.standobyte.jojo.command.JojoCommandsCommand;
import com.github.standobyte.jojo.command.StandCommand;
import com.github.standobyte.jojo.command.argument.StandArgument;
import com.github.standobyte.jojo.init.power.JojoCustomRegistries;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.weever.rotp_mwp.util.AddonUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={StandCommand.class})
public class StandCommandMixin {
    @Unique
    private static final DynamicCommandExceptionType GIVE_SINGLE_EXCEPTION_ALREADY_HAS = new DynamicCommandExceptionType(player -> new TranslationTextComponent("commands.stand.give.failed.single.has", new Object[]{player}));
    @Unique
    private static final DynamicCommandExceptionType GIVE_MULTIPLE_EXCEPTION_ALREADY_HAVE = new DynamicCommandExceptionType(count -> new TranslationTextComponent("commands.stand.give.failed.multiple.have", new Object[]{count}));
    @Unique
    private static final DynamicCommandExceptionType GIVE_SINGLE_EXCEPTION_RANDOM = new DynamicCommandExceptionType(player -> new TranslationTextComponent("commands.stand.give.failed.single.random", new Object[]{player}));
    @Unique
    private static final DynamicCommandExceptionType GIVE_MULTIPLE_EXCEPTION_RANDOM = new DynamicCommandExceptionType(count -> new TranslationTextComponent("commands.stand.give.failed.multiple.random", new Object[]{count}));
    @Unique
    private static final DynamicCommandExceptionType QUERY_SINGLE_FAILED_EXCEPTION = new DynamicCommandExceptionType(player -> new TranslationTextComponent("commands.stand.query.failed.single", new Object[]{player}));
    @Unique
    private static final DynamicCommandExceptionType QUERY_MULTIPLE_FAILED_EXCEPTION = new DynamicCommandExceptionType(count -> new TranslationTextComponent("commands.stand.query.failed.multiple", new Object[]{count}));

    @Overwrite
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"stand").requires(ctx -> ctx.func_197034_c(2))).then(Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"stand", (ArgumentType)new StandArgument()).executes(ctx -> StandCommandMixin.giveStands((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), StandArgument.getStandType((CommandContext)ctx, (String)"stand"), false))).then(Commands.func_197056_a((String)"replace", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> StandCommandMixin.giveStands((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), StandArgument.getStandType((CommandContext)ctx, (String)"stand"), BoolArgumentType.getBool((CommandContext)ctx, (String)"replace")))))))).then(Commands.func_197057_a((String)"random").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> StandCommandMixin.giveRandomStands((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), false))).then(Commands.func_197056_a((String)"replace", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> StandCommandMixin.giveRandomStands((CommandSource)ctx.getSource(), EntityArgument.func_197090_e((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"replace"))))))).then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> StandCommandMixin.removeStands((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets")))))).then(Commands.func_197057_a((String)"type").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> StandCommandMixin.queryStand((CommandSource)ctx.getSource(), EntityArgument.func_197088_a((CommandContext)ctx, (String)"targets"))))));
        JojoCommandsCommand.addCommand((String)"stand");
    }

    @Unique
    private static int giveStands(CommandSource source, Collection<? extends Entity> targets, StandType<?> standType, boolean replace) throws CommandSyntaxException {
        int i = 0;
        List listOfEntities = targets.stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).collect(Collectors.toList());
        if (!listOfEntities.isEmpty()) {
            for (LivingEntity entity2 : listOfEntities) {
                IStandPower power = (IStandPower)IStandPower.getStandPowerOptional((LivingEntity)entity2).orElse(null);
                if (power == null) continue;
                if (replace) {
                    power.clear();
                }
                if (power.givePower(standType)) {
                    ++i;
                    continue;
                }
                if (listOfEntities.size() != 1) continue;
                throw GIVE_SINGLE_EXCEPTION_ALREADY_HAS.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
            }
            if (i == 0) {
                if (listOfEntities.size() == 1) {
                    throw GIVE_SINGLE_EXCEPTION_ALREADY_HAS.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
                }
                throw GIVE_MULTIPLE_EXCEPTION_ALREADY_HAVE.create((Object)listOfEntities.size());
            }
            if (listOfEntities.size() == 1) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.give.success.single", new Object[]{standType.getName(), ((LivingEntity)listOfEntities.iterator().next()).func_145748_c_()}), true);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.give.success.multiple", new Object[]{standType.getName(), i}), true);
            }
            return i;
        }
        return i;
    }

    @Unique
    private static int giveRandomStands(CommandSource source, Collection<? extends Entity> targets, boolean replace) throws CommandSyntaxException {
        int i = 0;
        List listOfEntities = targets.stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).collect(Collectors.toList());
        StandType<?> stand = null;
        if (!listOfEntities.isEmpty()) {
            for (LivingEntity player : listOfEntities) {
                IStandPower power = (IStandPower)IStandPower.getStandPowerOptional((LivingEntity)player).orElse(null);
                if (power == null) continue;
                stand = AddonUtil.randomStand(player, player.func_70681_au());
                if (stand == null) {
                    if (listOfEntities.size() == 1) {
                        throw GIVE_SINGLE_EXCEPTION_RANDOM.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
                    }
                    throw GIVE_MULTIPLE_EXCEPTION_RANDOM.create((Object)(listOfEntities.size() - i));
                }
                if (replace) {
                    power.clear();
                }
                if (power.givePower(stand)) {
                    ++i;
                    continue;
                }
                if (listOfEntities.size() != 1) continue;
                throw GIVE_SINGLE_EXCEPTION_ALREADY_HAS.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
            }
        }
        if (i == 0) {
            if (listOfEntities.size() == 1) {
                throw GIVE_SINGLE_EXCEPTION_ALREADY_HAS.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
            }
            throw GIVE_MULTIPLE_EXCEPTION_ALREADY_HAVE.create((Object)listOfEntities.size());
        }
        if (listOfEntities.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.give.success.single.random", new Object[]{((LivingEntity)listOfEntities.iterator().next()).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.give.success.multiple.random", new Object[]{i}), true);
        }
        return i;
    }

    @Unique
    private static int removeStands(CommandSource source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        StandType removedStand = null;
        List listOfEntities = targets.stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).collect(Collectors.toList());
        for (LivingEntity entity2 : listOfEntities) {
            IStandPower power = (IStandPower)IStandPower.getStandPowerOptional((LivingEntity)entity2).orElse(null);
            if (power == null) continue;
            removedStand = (StandType)power.getType();
            power.clear();
            power.fullStandClear();
            ++i;
        }
        if (i == 0) {
            if (listOfEntities.size() == 1) {
                throw QUERY_SINGLE_FAILED_EXCEPTION.create((Object)((LivingEntity)listOfEntities.iterator().next()).func_200200_C_());
            }
            throw QUERY_MULTIPLE_FAILED_EXCEPTION.create((Object)listOfEntities.size());
        }
        if (listOfEntities.size() == 1) {
            TranslationTextComponent message = removedStand != null ? new TranslationTextComponent("commands.stand.remove.success.single", new Object[]{removedStand.getName(), ((LivingEntity)listOfEntities.iterator().next()).func_145748_c_()}) : new TranslationTextComponent("commands.stand.remove.success.single.no_stand", new Object[]{((LivingEntity)listOfEntities.iterator().next()).func_145748_c_()});
            source.func_197030_a((ITextComponent)message, true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.remove.success.multiple", new Object[]{i}), true);
        }
        return i;
    }

    @Unique
    private static int queryStand(CommandSource source, Entity entity) throws CommandSyntaxException {
        IStandPower power;
        if (entity instanceof LivingEntity && (power = (IStandPower)IStandPower.getStandPowerOptional((LivingEntity)((LivingEntity)entity)).orElse(null)) != null && power.hasPower()) {
            StandType type = (StandType)power.getType();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.stand.query.success", new Object[]{entity.func_145748_c_(), type.getName()}), false);
            return JojoCustomRegistries.STANDS.getNumericId(type.getRegistryName());
        }
        throw QUERY_SINGLE_FAILED_EXCEPTION.create((Object)entity.func_200200_C_());
    }
}

