/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.mixins;

import com.github.standobyte.jojo.entity.stand.StandEntity;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StandEntity.class})
public abstract class StandEntityMixin {
    @Unique
    private static final UUID BABY_ATTACK_DAMAGE_UUID = UUID.fromString("093864b1-a43a-459a-935d-627c78c630ed");
    @Unique
    private static final UUID BABY_ATTACK_SPEED_UUID = UUID.fromString("fa8875c2-a6a9-497a-9abd-564a58b5676b");
    @Unique
    private static final UUID BABY_REACH_DISTANCE_UUID = UUID.fromString("02438d49-4957-4501-a94b-21436baa9a14");
    @Unique
    private static final String MODIFIER_NAME = "Baby Stand debuff";
    @Unique
    private static final double DAMAGE_MODIFIER = -2.0;
    @Unique
    private static final double SPEED_MODIFIER = -2.5;
    @Unique
    private static final double REACH_MODIFIER = -2.0;
    @Unique
    private static final float BABY_HEIGHT_THRESHOLD = 1.5f;
    @Unique
    private boolean rotp_mwp$isBabyAttributeApplied = false;

    @Inject(method={"isBaby"}, at={@At(value="HEAD")}, cancellable=true)
    private void rotp_mwp$isBaby(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity user = ((StandEntity)this).getUser();
        if (user == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (user.func_70631_g_() || user.func_213302_cg() < 1.5f) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void rotp_mwp$tick(CallbackInfo ci) {
        StandEntity standEntity = (StandEntity)this;
        boolean shouldBeBaby = standEntity.func_70631_g_();
        if (shouldBeBaby && !this.rotp_mwp$isBabyAttributeApplied) {
            float scaleFactor = 1.0f;
            if (standEntity.getUser() != null) {
                scaleFactor = Math.max(0.1f, standEntity.getUser().func_213302_cg() / 1.5f);
            }
            this.applyBabyAttributes((LivingEntity)standEntity, scaleFactor);
            this.rotp_mwp$isBabyAttributeApplied = true;
        } else if (!shouldBeBaby && this.rotp_mwp$isBabyAttributeApplied) {
            this.removeBabyAttributes((LivingEntity)standEntity);
            this.rotp_mwp$isBabyAttributeApplied = false;
        }
    }

    @Inject(method={"defaultRotation"}, at={@At(value="HEAD")}, cancellable=true)
    private void rotp_mwp$defaultRotation(CallbackInfo ci) {
        StandEntity standEntity = (StandEntity)this;
        LivingEntity user = standEntity.getUser();
        if (user != null && !standEntity.isManuallyControlled() && !standEntity.isRemotePositionFixed()) {
            if (user instanceof MobEntity && ((MobEntity)user).func_70638_az() != null) {
                LivingEntity target = ((MobEntity)user).func_70638_az();
                double deltaX = target.func_226277_ct_() - standEntity.func_226277_ct_();
                double deltaY = target.func_226280_cw_() - standEntity.func_226280_cw_();
                double deltaZ = target.func_226281_cx_() - standEntity.func_226281_cx_();
                double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                float yRot = (float)(Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0);
                float xRot = (float)(-Math.toDegrees(Math.atan2(deltaY, horizontalDistance)));
                standEntity.func_70101_b(yRot, xRot);
                standEntity.func_70034_d(yRot);
            } else {
                standEntity.func_70101_b(user.field_70177_z, user.field_70125_A);
                standEntity.func_70034_d(user.field_70759_as);
            }
        }
        ci.cancel();
    }

    @Unique
    private void applyBabyAttributes(LivingEntity entity, float scaleFactor) {
        this.applyModifier(entity, Attributes.field_233823_f_, BABY_ATTACK_DAMAGE_UUID, -2.0 * (double)scaleFactor, AttributeModifier.Operation.ADDITION);
        this.applyModifier(entity, Attributes.field_233825_h_, BABY_ATTACK_SPEED_UUID, -2.5 * (double)scaleFactor, AttributeModifier.Operation.ADDITION);
        this.applyModifier(entity, (Attribute)ForgeMod.REACH_DISTANCE.get(), BABY_REACH_DISTANCE_UUID, -2.0 * (double)scaleFactor, AttributeModifier.Operation.ADDITION);
    }

    @Unique
    private void removeBabyAttributes(LivingEntity entity) {
        this.removeModifier(entity, Attributes.field_233823_f_, BABY_ATTACK_DAMAGE_UUID);
        this.removeModifier(entity, Attributes.field_233825_h_, BABY_ATTACK_SPEED_UUID);
        this.removeModifier(entity, (Attribute)ForgeMod.REACH_DISTANCE.get(), BABY_REACH_DISTANCE_UUID);
    }

    @Unique
    private void applyModifier(LivingEntity entity, Attribute attribute, UUID uuid, double value, AttributeModifier.Operation operation) {
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(attribute);
        if (attributeInstance != null) {
            attributeInstance.func_188479_b(uuid);
            attributeInstance.func_233767_b_(new AttributeModifier(uuid, MODIFIER_NAME, value, operation));
        }
    }

    @Unique
    private void removeModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(attribute);
        if (attributeInstance != null) {
            attributeInstance.func_188479_b(uuid);
        }
    }
}

