/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.util;

import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.action.stand.TimeStop;
import com.github.standobyte.jojo.entity.mob.rps.RockPaperScissorsKidEntity;
import com.github.standobyte.jojo.init.power.JojoCustomRegistries;
import com.github.standobyte.jojo.power.impl.nonstand.type.NonStandPowerType;
import com.github.standobyte.jojo.power.impl.stand.IStandPower;
import com.github.standobyte.jojo.power.impl.stand.StandUtil;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import com.github.standobyte.jojo.util.general.MathUtil;
import com.github.standobyte.jojo.util.mod.JojoModUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.weever.rotp_mwp.Config;
import net.weever.rotp_mwp.util.CapabilityAdderForAll;

@Mod.EventBusSubscriber(modid="rotp_mwp")
public class AddonUtil {
    private static final String PROCESSED_TAG = "rotp_mwp:processed";

    private static boolean isGECreated(Entity entity) {
        CompoundNBT nbt = new CompoundNBT();
        entity.func_189511_e(nbt);
        if (nbt.func_150297_b("DeathLootTable", 8)) {
            return nbt.func_74779_i("DeathLootTable").equals("empty");
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMobSpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.func_201670_d() || !(entity instanceof MobEntity) || CapabilityAdderForAll.isBlockedEntity(entity) || entity.getPersistentData().func_74767_n(PROCESSED_TAG) || AddonUtil.isGECreated(entity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        Random random = new Random();
        if (random.nextFloat() < AddonUtil.calculateFromPercentageToFloat(AddonUtil.getPercentageOfGettingStand(false))) {
            IStandPower.getStandPowerOptional((LivingEntity)mobEntity).ifPresent(power -> {
                if (!power.hasPower()) {
                    if (mobEntity instanceof VillagerEntity && mobEntity.func_70631_g_() && ((Boolean)Config.getCommonConfigInstance((boolean)false).spawnBoy2Man.get()).booleanValue()) {
                        RockPaperScissorsKidEntity.turnFromArrow((Entity)mobEntity);
                    } else {
                        power.givePower(AddonUtil.randomStand((LivingEntity)mobEntity, random));
                    }
                    power.setResolveLevel(random.nextInt(4));
                }
            });
        }
        entity.getPersistentData().func_74757_a(PROCESSED_TAG, true);
    }

    public static List<StandAction> getListOfUnlockedStandActions(IStandPower power) {
        ArrayList<StandAction> actions = new ArrayList<StandAction>();
        Random random = power.getUser().field_70170_p.field_73012_v;
        for (StandAction action : power.getAllUnlockedActions()) {
            int maxTicks;
            if (action instanceof TimeStop && (maxTicks = ((TimeStop)action).getMaxTimeStopTicks(power)) > 0) {
                int randomTicks = random.nextInt(maxTicks + 1);
                power.setLearningProgressPoints(action, (float)randomTicks);
            }
            actions.add(action);
        }
        return actions;
    }

    @Nullable
    public static StandType<?> randomStand(LivingEntity entity, Random random) {
        if (!entity.field_70170_p.func_201670_d()) {
            List<? extends String> blockedStands;
            List stands = StandUtil.arrowStands((boolean)entity.field_70170_p.func_201670_d()).collect(Collectors.toList());
            if (stands.isEmpty()) {
                return null;
            }
            if (!((Boolean)Config.getCommonConfigInstance((boolean)entity.field_70170_p.func_201670_d()).useAddonStands.get()).booleanValue()) {
                stands.removeIf(stand -> !Objects.requireNonNull(stand.getRegistryName()).toString().startsWith("jojo"));
            }
            if (!(blockedStands = AddonUtil.getBlockedStandsForMobsList(entity.field_70170_p.func_201670_d())).isEmpty()) {
                stands.removeIf(stand -> blockedStands.contains(Objects.requireNonNull(stand.getRegistryName()).toString()));
            }
            return MathUtil.getRandomWeightedDouble(stands, stand -> stand.getStats().getRandomWeight(), (Random)random).orElse(null);
        }
        return null;
    }

    @Nullable
    public static NonStandPowerType<?> randomPower(LivingEntity entity, Random random) {
        if (!entity.field_70170_p.func_201670_d()) {
            Collection powers = JojoCustomRegistries.NON_STAND_POWERS.getRegistry().getValues();
            if (powers.isEmpty()) {
                return null;
            }
            return (NonStandPowerType)AddonUtil.getRandomElement(powers, random);
        }
        return null;
    }

    public static List<? extends String> getBlockedEntitiesList(boolean clientSide) {
        return (List)Config.getCommonConfigInstance((boolean)clientSide).blockedEntities.get();
    }

    public static List<? extends String> getBlockedStandsForMobsList(boolean clientSide) {
        return (List)Config.getCommonConfigInstance((boolean)clientSide).blockedStandsForMobs.get();
    }

    public static List<? extends String> getBlockedStandActionsList(boolean clientSide) {
        return (List)Config.getCommonConfigInstance((boolean)clientSide).blockedStandActionsForMobs.get();
    }

    public static List<? extends String> getLongRangeStandsList(boolean clientSide) {
        return (List)Config.getCommonConfigInstance((boolean)clientSide).longRangeStands.get();
    }

    public static int getPercentageOfGettingStand(boolean clientSide) {
        return (Integer)Config.getCommonConfigInstance((boolean)clientSide).percentageChanceToGettingAStandForMob.get();
    }

    public static float calculateFromPercentageToFloat(int percentage) {
        return (float)percentage / 100.0f;
    }

    public static ActionTarget getActionTarget(LivingEntity livingEntity) {
        RayTraceResult rayTrace = JojoModUtil.rayTrace((Vector3d)livingEntity.func_174824_e(1.0f), (Vector3d)livingEntity.func_70040_Z(), (double)3.0, (World)livingEntity.field_70170_p, (Entity)livingEntity, e -> !e.func_70028_i((Entity)livingEntity), (double)0.0, (double)0.0);
        ActionTarget target = ActionTarget.fromRayTraceResult((RayTraceResult)rayTrace);
        target.resolveEntityId(livingEntity.field_70170_p);
        return target;
    }

    public static float getStandRange(StandType<?> standType, World level) {
        if (standType == null) {
            return 0.0f;
        }
        if (CapabilityAdderForAll.isLongRangeStand(standType, level)) {
            return 32.0f;
        }
        return 12.5f;
    }

    public static <T> T getRandomElement(Iterable<T> items, Random random) {
        List itemList = StreamSupport.stream(items.spliterator(), false).collect(Collectors.toList());
        return itemList.get(random.nextInt(itemList.size()));
    }
}

