/*
 * Decompiled with CFR 0.152.
 */
package net.weever.rotp_mwp.util;

import com.github.standobyte.jojo.action.stand.StandAction;
import com.github.standobyte.jojo.capability.entity.power.NonStandCapProvider;
import com.github.standobyte.jojo.capability.entity.power.StandCapProvider;
import com.github.standobyte.jojo.entity.SoulEntity;
import com.github.standobyte.jojo.entity.mob.IMobPowerUser;
import com.github.standobyte.jojo.entity.mob.IMobStandUser;
import com.github.standobyte.jojo.entity.stand.StandEntity;
import com.github.standobyte.jojo.init.power.stand.ModStandsInit;
import com.github.standobyte.jojo.power.impl.stand.type.StandType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.weever.rotp_mwp.Config;
import net.weever.rotp_mwp.mechanics.combo.ComboManager;
import net.weever.rotp_mwp.util.AddonUtil;

@Mod.EventBusSubscriber(modid="rotp_mwp")
public class CapabilityAdderForAll {
    public static final List<Class<?>> blockedEntities = (List)Util.func_200696_a(new ArrayList(), list -> {
        list.add(PlayerEntity.class);
        list.add(StandEntity.class);
        list.add(EnderDragonEntity.class);
        list.add(IMobPowerUser.class);
        list.add(IMobStandUser.class);
        list.add(SoulEntity.class);
    });
    private static final ArrayList<String> blockedStandActions = (ArrayList)Util.func_200696_a(new ArrayList(), list -> {
        list.add(ModStandsInit.STAR_PLATINUM_ZOOM.getId().toString());
        list.add(ModStandsInit.CRAZY_DIAMOND_REPAIR.getId().toString());
        list.add(ModStandsInit.CRAZY_DIAMOND_BLOCK_ANCHOR_MOVE.getId().toString());
    });
    private static final ResourceLocation STAND_CAP = new ResourceLocation("jojo", "stand");
    private static final ResourceLocation NON_STAND_CAP = new ResourceLocation("jojo", "non_stand");

    @SubscribeEvent
    public static void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof LivingEntity && !CapabilityAdderForAll.isBlockedEntity(entity)) {
            LivingEntity living = (LivingEntity)entity;
            event.addCapability(STAND_CAP, (ICapabilityProvider)new StandCapProvider(living));
            event.addCapability(NON_STAND_CAP, (ICapabilityProvider)new NonStandCapProvider(living));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ComboManager());
    }

    public static boolean isBlockedEntity(Entity entity) {
        if (((Boolean)Config.getCommonConfigInstance((boolean)entity.field_70170_p.func_201670_d()).smallAnarchyWithStands.get()).booleanValue()) {
            blockedEntities.remove(StandEntity.class);
        }
        try {
            String uniqueId = entity.func_200600_R().getRegistryName().toString();
            return blockedEntities.stream().anyMatch(clazz -> clazz.isAssignableFrom(entity.getClass())) || AddonUtil.getBlockedEntitiesList(entity.field_70170_p.func_201670_d()).contains(uniqueId);
        }
        catch (NullPointerException exception) {
            return blockedEntities.stream().anyMatch(clazz -> clazz.isAssignableFrom(entity.getClass()));
        }
    }

    public static boolean isBlockedAction(StandAction standAction, World level) {
        try {
            String uniqueId = standAction.getRegistryName().toString();
            return blockedStandActions.contains(uniqueId) || AddonUtil.getBlockedStandActionsList(level.func_201670_d()).contains(uniqueId);
        }
        catch (NullPointerException exception) {
            return true;
        }
    }

    public static boolean isLongRangeStand(StandType<?> standType, World level) {
        try {
            String uniqueId = standType.getRegistryName().toString();
            return AddonUtil.getLongRangeStandsList(level.func_201670_d()).contains(uniqueId);
        }
        catch (NullPointerException exception) {
            return false;
        }
    }
}

