/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigClient;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.client.ScreenWand;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.network.PacketQueryUndo;
import thetadev.constructionwand.network.PacketWandOption;

public class ClientEvents {
    private boolean optPressed = false;
    private boolean leftShiftPressed = false;

    @SubscribeEvent
    public void KeyEvent(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (WandUtil.holdingWand((Player)player) == null) {
            return;
        }
        boolean optState = ClientEvents.isOptKeyDown();
        boolean leftShiftState = ClientEvents.isLeftShiftKeyDown();
        if (this.optPressed != optState || this.leftShiftPressed != leftShiftState) {
            this.optPressed = optState;
            this.leftShiftPressed = leftShiftState;
            PacketQueryUndo packet = new PacketQueryUndo(this.optPressed, this.leftShiftPressed);
            ConstructionWand.instance.HANDLER.sendToServer((Object)packet);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void MouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double scroll = event.getScrollDelta();
        if (!ClientEvents.modeKeyCombDown() || scroll == 0.0) {
            return;
        }
        ItemStack wand = WandUtil.holdingWand((Player)player);
        if (wand == null) {
            return;
        }
        WandOptions wandOptions = new WandOptions(wand);
        wandOptions.lock.next(scroll < 0.0);
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(wandOptions.lock, true));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (!ClientEvents.modeKeyCombDown()) {
            return;
        }
        ItemStack wand = event.getItemStack();
        if (!(wand.m_41720_() instanceof ItemWand)) {
            return;
        }
        WandOptions wandOptions = new WandOptions(wand);
        wandOptions.cores.next();
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(wandOptions.cores, true));
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide().isServer()) {
            return;
        }
        if (!ClientEvents.guiKeyCombDown()) {
            return;
        }
        ItemStack wand = event.getItemStack();
        if (!(wand.m_41720_() instanceof ItemWand)) {
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new ScreenWand(wand));
        event.setCanceled(true);
    }

    private static boolean isKeyDown(int id) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)id);
    }

    public static boolean isLeftShiftKeyDown() {
        return ClientEvents.isKeyDown(340);
    }

    public static boolean isOptKeyDown() {
        return ClientEvents.isKeyDown((Integer)ConfigClient.OPT_KEY.get());
    }

    public static boolean modeKeyCombDown() {
        return ClientEvents.isOptKeyDown() && (ClientEvents.isLeftShiftKeyDown() || (Boolean)ConfigClient.SHIFTOPT_MODE.get() == false);
    }

    public static boolean guiKeyCombDown() {
        return ClientEvents.isOptKeyDown() && (ClientEvents.isLeftShiftKeyDown() || (Boolean)ConfigClient.SHIFTOPT_GUI.get() == false);
    }
}

