/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.client.ClientEvents;
import thetadev.constructionwand.network.PacketRequestPreview;

public class RenderBlockPreview {
    private BlockHitResult lastRayTraceResult = null;
    private ItemStack lastWand = ItemStack.f_41583_;
    public Set<BlockPos> undoBlocks;
    public Set<BlockPos> previewBlocks;

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Set<BlockPos> blocks;
        if (event.getTarget().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult rtr = event.getTarget();
        Entity entity = event.getCamera().m_90592_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float colorR = 0.0f;
        float colorG = 0.0f;
        float colorB = 0.0f;
        ItemStack wand = WandUtil.holdingWand(player);
        if (wand == null) {
            return;
        }
        if (ClientEvents.isOptKeyDown()) {
            blocks = this.undoBlocks;
            colorG = 1.0f;
        } else {
            if (this.lastRayTraceResult == null || !RenderBlockPreview.compareRTR(this.lastRayTraceResult, rtr) || this.lastWand.equals(wand) || this.previewBlocks.size() < 2) {
                this.lastRayTraceResult = rtr;
                this.lastWand = wand;
                ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketRequestPreview(rtr, wand));
            }
            blocks = this.previewBlocks;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        VertexConsumer lineBuilder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        double partialTicks = event.getPartialTick();
        double d0 = player.f_19790_ + (player.m_20185_() - player.f_19790_) * partialTicks;
        double d1 = player.f_19791_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19791_) * partialTicks;
        double d2 = player.f_19792_ + (player.m_20189_() - player.f_19792_) * partialTicks;
        for (BlockPos block : blocks) {
            AABB aabb = new AABB(block).m_82386_(-d0, -d1, -d2);
            LevelRenderer.m_109646_((PoseStack)ms, (VertexConsumer)lineBuilder, (AABB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
        }
        event.setCanceled(true);
    }

    public void reset() {
        this.lastRayTraceResult = null;
        this.lastWand = ItemStack.f_41583_;
        this.previewBlocks = null;
    }

    private static boolean compareRTR(BlockHitResult rtr1, BlockHitResult rtr2) {
        return rtr1.m_82425_().equals((Object)rtr2.m_82425_()) && rtr1.m_82434_().equals((Object)rtr2.m_82434_());
    }
}

