/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers;

import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.containers.ContainerTrace;

public class ContainerManager {
    private final ArrayList<IContainerHandler> handlers = new ArrayList();

    public boolean register(IContainerHandler handler) {
        return this.handlers.add(handler);
    }

    public int countItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack) {
        for (IContainerHandler handler : this.handlers) {
            if (!handler.matches(player, inventoryStack)) continue;
            int sig = handler.getSignature(player, inventoryStack);
            if (trace.push(sig)) {
                int count = handler.countItems(player, trace, itemStack, inventoryStack);
                return count;
            }
            return 0;
        }
        return 0;
    }

    public int useItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack, int count) {
        for (IContainerHandler handler : this.handlers) {
            if (!handler.matches(player, inventoryStack)) continue;
            int sig = handler.getSignature(player, inventoryStack);
            if (trace.push(sig)) {
                int remaining = handler.useItems(player, trace, itemStack, inventoryStack, count);
                return remaining;
            }
            return count;
        }
        return count;
    }
}

