/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import thetadev.constructionwand.ConstructionWand;

public class PacketQueryUndo {
    public boolean undoPressed;
    public boolean shiftPressed;

    public PacketQueryUndo(boolean undoPressed, boolean shiftPressed) {
        this.undoPressed = undoPressed;
        this.shiftPressed = shiftPressed;
    }

    public static void encode(PacketQueryUndo msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.undoPressed);
        buffer.writeBoolean(msg.shiftPressed);
    }

    public static PacketQueryUndo decode(FriendlyByteBuf buffer) {
        return new PacketQueryUndo(buffer.readBoolean(), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketQueryUndo msg, Supplier<NetworkEvent.Context> ctx) {
            if (!ctx.get().getDirection().getReceptionSide().isServer()) {
                return;
            }
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return;
            }
            ConstructionWand.instance.undoHistory.updateClient((Player)player, msg.undoPressed, msg.shiftPressed);
        }
    }
}

