/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.supplier;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ReplacementRegistry;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.basics.pool.IPool;
import thetadev.constructionwand.basics.pool.OrderedPool;
import thetadev.constructionwand.containers.ContainerManager;
import thetadev.constructionwand.containers.ContainerTrace;
import thetadev.constructionwand.wand.undo.PlaceSnapshot;

public class SupplierInventory
implements IWandSupplier {
    protected final Player player;
    protected final WandOptions options;
    protected HashMap<BlockItem, Integer> itemCounts;
    protected IPool<BlockItem> itemPool;

    public SupplierInventory(Player player, WandOptions options) {
        this.player = player;
        this.options = options;
    }

    @Override
    public void getSupply(@Nullable BlockItem target) {
        this.itemCounts = new LinkedHashMap<BlockItem, Integer>();
        ItemStack offhandStack = this.player.m_21120_(InteractionHand.OFF_HAND);
        this.itemPool = new OrderedPool<BlockItem>();
        if (!offhandStack.m_41619_() && offhandStack.m_41720_() instanceof BlockItem) {
            this.addBlockItem((BlockItem)offhandStack.m_41720_());
        } else if (target != null && target != Items.f_41852_) {
            this.addBlockItem(target);
            if (this.options.match.get() != WandOptions.MATCH.EXACT) {
                for (Item it : ReplacementRegistry.getMatchingSet((Item)target)) {
                    if (!(it instanceof BlockItem)) continue;
                    this.addBlockItem((BlockItem)it);
                }
            }
        }
    }

    protected void addBlockItem(BlockItem item) {
        int count = WandUtil.countItem(this.player, (Item)item);
        if (count > 0) {
            this.itemCounts.put(item, count);
            this.itemPool.add(item);
        }
    }

    @Override
    @Nullable
    public PlaceSnapshot getPlaceSnapshot(Level world, BlockPos pos, BlockHitResult rayTraceResult, @Nullable BlockState supportingBlock) {
        PlaceSnapshot placeSnapshot;
        BlockItem item;
        int count;
        if (!WandUtil.isPositionPlaceable(world, this.player, pos, this.options.replace.get())) {
            return null;
        }
        this.itemPool.reset();
        do {
            if ((item = this.itemPool.draw()) != null) continue;
            return null;
        } while ((count = this.itemCounts.get(item).intValue()) == 0 || (placeSnapshot = PlaceSnapshot.get(world, this.player, rayTraceResult, pos, item, supportingBlock, this.options)) == null);
        int ncount = count - 1;
        this.itemCounts.put(item, ncount);
        if (ncount == 0) {
            this.itemPool.remove(item);
        }
        return placeSnapshot;
    }

    @Override
    public int takeItemStack(ItemStack stack) {
        int count = stack.m_41613_();
        Item item = stack.m_41720_();
        if (this.player.m_150109_().f_35974_ == null) {
            return count;
        }
        if (this.player.m_7500_()) {
            return 0;
        }
        List<ItemStack> hotbar = WandUtil.getHotbarWithOffhand(this.player);
        List<ItemStack> mainInv = WandUtil.getMainInv(this.player);
        List<ItemStack> armor = WandUtil.getArmor(this.player);
        List<ItemStack> curios = WandUtil.getCuriosInv(this.player);
        count = this.takeItemsInvList(count, item, mainInv, false);
        count = this.takeItemsInvList(count, item, mainInv, true);
        count = this.takeItemsInvList(count, item, hotbar, true);
        count = this.takeItemsInvList(count, item, hotbar, false);
        count = this.takeItemsInvList(count, item, armor, true);
        count = this.takeItemsInvList(count, item, armor, false);
        count = this.takeItemsInvList(count, item, curios, true);
        count = this.takeItemsInvList(count, item, curios, false);
        return count;
    }

    private int takeItemsInvList(int count, Item item, List<ItemStack> inv, boolean container) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ContainerManager containerManager = ConstructionWand.instance.containerManager;
            ContainerTrace trace = new ContainerTrace(serverPlayer);
            for (ItemStack stack : inv) {
                if (count == 0) break;
                if (container) {
                    count = containerManager.useItems((Player)serverPlayer, trace, new ItemStack((ItemLike)item), stack, count);
                }
                if (container || !WandUtil.stackEquals(stack, item)) continue;
                int toTake = Math.min(count, stack.m_41613_());
                stack.m_41774_(toTake);
                count -= toTake;
                serverPlayer.m_150109_().m_6596_();
            }
        }
        return count;
    }
}

