/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import com.tom.storagemod.Config;
import com.tom.storagemod.item.AdvWirelessTerminalItem;
import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.StoredItemStack;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.containers.ContainerTrace;

public class HandlerAdvWirelessTerminal
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack inventoryStack) {
        return inventoryStack.m_41720_() instanceof AdvWirelessTerminalItem;
    }

    @Override
    public int getSignature(Player player, ItemStack inventoryStack) {
        CompoundTag tag = inventoryStack.m_41783_();
        if (tag == null) {
            return -1;
        }
        if (!(tag.m_128441_("BindX") && tag.m_128441_("BindY") && tag.m_128441_("BindZ") && tag.m_128441_("BindDim"))) {
            return -1;
        }
        int x = tag.m_128451_("BindX");
        int y = tag.m_128451_("BindY");
        int z = tag.m_128451_("BindZ");
        String dim = tag.m_128461_("BindDim");
        return x * 31 + y * 17 + z ^ dim.hashCode();
    }

    @Override
    public int countItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack) {
        if (!(player instanceof ServerPlayer)) {
            return 0;
        }
        StorageTerminalBlockEntity terminal = this.resolveTerminal(player, inventoryStack);
        if (terminal == null) {
            return 0;
        }
        int found = 0;
        for (Map.Entry entry : terminal.getStacks().entrySet()) {
            if (!WandUtil.stackEquals(((StoredItemStack)entry.getKey()).getStack(), itemStack) || (found = (int)((long)found + (Long)entry.getValue())) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return found;
    }

    @Override
    public int useItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack, int count) {
        if (!(player instanceof ServerPlayer)) {
            return count;
        }
        StorageTerminalBlockEntity terminal = this.resolveTerminal(player, inventoryStack);
        if (terminal == null) {
            return count;
        }
        long extracted = terminal.pullStack(new StoredItemStack(itemStack, (long)count), (long)count).getQuantity();
        return count - (int)extracted;
    }

    private StorageTerminalBlockEntity resolveTerminal(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (!(tag.m_128441_("BindX") && tag.m_128441_("BindY") && tag.m_128441_("BindZ") && tag.m_128441_("BindDim"))) {
            return null;
        }
        int x = tag.m_128451_("BindX");
        int y = tag.m_128451_("BindY");
        int z = tag.m_128451_("BindZ");
        BlockPos pos = new BlockPos(x, y, z);
        String dim = tag.m_128461_("BindDim");
        ServerLevel termWorld = player.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim)));
        if (termWorld == null || !termWorld.m_46749_(pos)) {
            return null;
        }
        BlockEntity be = termWorld.m_7702_(pos);
        if (be instanceof StorageTerminalBlockEntity) {
            StorageTerminalBlockEntity terminal = (StorageTerminalBlockEntity)be;
            terminal.updateServer();
            return this.canInteractWith(terminal, player) ? terminal : null;
        }
        return null;
    }

    private boolean canInteractWith(StorageTerminalBlockEntity terminal, Player player) {
        int d = 4;
        int termReach = Config.get().advWirelessRange;
        int beaconLevel = terminal.getBeaconLevel();
        if (Config.get().wirelessTermBeaconLvl != -1 && beaconLevel >= Config.get().wirelessTermBeaconLvl && termReach > 0) {
            if (Config.get().wirelessTermBeaconLvlDim != -1 && beaconLevel >= Config.get().wirelessTermBeaconLvlDim) {
                return true;
            }
            return player.m_9236_() == terminal.m_58904_();
        }
        d = Math.max(d, termReach);
        return player.m_9236_() == terminal.m_58904_() && !(player.m_20275_((double)terminal.m_58899_().m_123341_() + 0.5, (double)terminal.m_58899_().m_123342_() + 0.5, (double)terminal.m_58899_().m_123343_() + 0.5) > (double)(d * 2 * d * 2));
    }
}

