/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.containers.ContainerTrace;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.item.BlockProvider;

public class HandlerBotania
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCapability(BotaniaForgeCapabilities.BLOCK_PROVIDER).isPresent();
    }

    @Override
    public int getSignature(Player player, ItemStack inventoryStack) {
        return inventoryStack.hashCode();
    }

    @Override
    public int countItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack) {
        Optional provOptional = inventoryStack.getCapability(BotaniaForgeCapabilities.BLOCK_PROVIDER).resolve();
        if (provOptional.isEmpty()) {
            return 0;
        }
        BlockProvider prov = (BlockProvider)provOptional.get();
        int provCount = prov.getBlockCount(player, inventoryStack, Block.m_49814_((Item)itemStack.m_41720_()));
        if (provCount == -1) {
            return Integer.MAX_VALUE;
        }
        return provCount;
    }

    @Override
    public int useItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack, int count) {
        Optional provOptional = inventoryStack.getCapability(BotaniaForgeCapabilities.BLOCK_PROVIDER).resolve();
        if (provOptional.isEmpty()) {
            return 0;
        }
        BlockProvider prov = (BlockProvider)provOptional.get();
        if (prov.provideBlock(player, inventoryStack, Block.m_49814_((Item)itemStack.m_41720_()), true)) {
            return 0;
        }
        return count;
    }
}

