/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.containers.ContainerTrace;

public class HandlerCapability
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
    }

    @Override
    public int getSignature(Player player, ItemStack inventoryStack) {
        return inventoryStack.hashCode();
    }

    @Override
    public int countItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack) {
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        int total = 0;
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack containerStack = itemHandler.getStackInSlot(i);
            if (WandUtil.stackEquals(itemStack, containerStack)) {
                total += Math.max(0, containerStack.m_41613_());
                continue;
            }
            total += ConstructionWand.instance.containerManager.countItems(player, trace, itemStack, containerStack);
        }
        return total;
    }

    @Override
    public int useItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack, int count) {
        Optional itemHandlerOptional = inventoryStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerOptional.isEmpty()) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack handlerStack = itemHandler.getStackInSlot(i);
            if (WandUtil.stackEquals(itemStack, handlerStack)) {
                ItemStack extracted;
                if ((count -= (extracted = itemHandler.extractItem(i, count, false)).m_41613_()) > 0) continue;
                break;
            }
            int before = count;
            if ((count = ConstructionWand.instance.containerManager.useItems(player, trace, itemStack, handlerStack, count)) < before && count <= 0) break;
        }
        return count;
    }
}

