/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.item.WirelessGridItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.containers.ContainerTrace;

public class HandlerWirelessGrid
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack inventoryStack) {
        return inventoryStack.m_41720_() instanceof WirelessGridItem;
    }

    @Override
    public int getSignature(Player player, ItemStack inventoryStack) {
        CompoundTag tag = inventoryStack.m_41783_();
        if (tag == null) {
            return -1;
        }
        if (!(tag.m_128441_("NodeX") && tag.m_128441_("NodeY") && tag.m_128441_("NodeZ") && tag.m_128441_("Dimension"))) {
            return -1;
        }
        int x = tag.m_128451_("NodeX");
        int y = tag.m_128451_("NodeY");
        int z = tag.m_128451_("NodeZ");
        String dim = tag.m_128461_("Dimension");
        return x * 31 + y * 17 + z ^ dim.hashCode();
    }

    @Override
    public int countItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack) {
        INetwork network = this.resolveNetwork(player, inventoryStack);
        if (network == null) {
            return 0;
        }
        int extractCost = RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage();
        IEnergyStorage energy = (IEnergyStorage)inventoryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (energy == null) {
            return 0;
        }
        int energyStored = energy.getEnergyStored();
        int maxByEnergy = energyStored / extractCost;
        if (maxByEnergy <= 0) {
            player.m_5661_((Component)Component.m_237115_((String)"misc.refinedstorage.wireless_grid.out_of_energy"), true);
            return 0;
        }
        ItemStack simulated = network.extractItem(itemStack, maxByEnergy, Action.SIMULATE);
        return simulated.m_41619_() ? 0 : simulated.m_41613_();
    }

    @Override
    public int useItems(Player player, ContainerTrace trace, ItemStack itemStack, ItemStack inventoryStack, int count) {
        int canExtract;
        INetwork network = this.resolveNetwork(player, inventoryStack);
        if (network == null) {
            player.m_5661_((Component)Component.m_237115_((String)"misc.refinedstorage.wireless_grid.not_bound"), true);
            return count;
        }
        int extractCost = RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage();
        IEnergyStorage energy = (IEnergyStorage)inventoryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (energy == null) {
            return count;
        }
        int energyStored = energy.getEnergyStored();
        int maxByEnergy = energyStored / extractCost;
        if (maxByEnergy <= 0) {
            player.m_5661_((Component)Component.m_237115_((String)"misc.refinedstorage.wireless_grid.out_of_energy"), true);
            return count;
        }
        int effectiveRequest = Math.min(count, maxByEnergy);
        ItemStack extractedSim = network.extractItem(itemStack, effectiveRequest, Action.SIMULATE);
        int n = canExtract = extractedSim.m_41619_() ? 0 : extractedSim.m_41613_();
        if (canExtract <= 0) {
            return count;
        }
        ItemStack extracted = network.extractItem(itemStack, canExtract, Action.PERFORM);
        int actuallyExtracted = extracted.m_41619_() ? 0 : extracted.m_41613_();
        energy.extractEnergy(actuallyExtracted * extractCost, false);
        return count - actuallyExtracted;
    }

    private INetwork resolveNetwork(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (!(tag.m_128441_("NodeX") && tag.m_128441_("NodeY") && tag.m_128441_("NodeZ") && tag.m_128441_("Dimension"))) {
            return null;
        }
        int x = tag.m_128451_("NodeX");
        int y = tag.m_128451_("NodeY");
        int z = tag.m_128451_("NodeZ");
        BlockPos pos = new BlockPos(x, y, z);
        String dim = tag.m_128461_("Dimension");
        ServerLevel termWorld = player.m_9236_().m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim)));
        if (termWorld == null || !termWorld.m_46749_(pos)) {
            return null;
        }
        BlockEntity be = termWorld.m_7702_(pos);
        if (be instanceof INetworkNodeProxy) {
            INetworkNodeProxy proxy = (INetworkNodeProxy)be;
            INetworkNode node = proxy.getNode();
            return node != null ? node.getNetwork() : null;
        }
        return null;
    }
}

