/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.containers.ContainerTrace;

public class HandlerWirelessTerminal
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack inventoryStack) {
        return inventoryStack.m_41720_() instanceof WirelessTerminalItem;
    }

    @Override
    public int getSignature(Player player, ItemStack inventoryStack) {
        ServerPlayer serverPlayer;
        MEStorage storage;
        if (player instanceof ServerPlayer && (storage = this.getStorage(serverPlayer = (ServerPlayer)player, inventoryStack)) != null) {
            return storage.hashCode();
        }
        return -1;
    }

    @Override
    public int countItems(Player player, ContainerTrace trace, ItemStack target, ItemStack terminal) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MEStorage storage = this.getStorage(serverPlayer, terminal);
            if (storage == null) {
                return 0;
            }
            AEItemKey key = AEItemKey.of((ItemStack)target);
            if (key == null) {
                return 0;
            }
            long amount = 0L;
            for (Object2LongMap.Entry entry : storage.getAvailableStacks()) {
                if (!((AEKey)entry.getKey()).equals(key)) continue;
                amount = entry.getLongValue();
                break;
            }
            return amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        }
        return 0;
    }

    @Override
    public int useItems(Player player, ContainerTrace trace, ItemStack target, ItemStack terminal, int count) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MEStorage storage = this.getStorage(serverPlayer, terminal);
            if (storage == null) {
                return count;
            }
            AEItemKey key = AEItemKey.of((ItemStack)target);
            if (key == null) {
                return count;
            }
            long extracted = storage.extract((AEKey)key, (long)count, Actionable.MODULATE, null);
            long remaining = count - (int)extracted;
            return remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
        }
        return count;
    }

    private MEStorage getStorage(ServerPlayer player, ItemStack terminal) {
        Item item = terminal.m_41720_();
        if (item instanceof WirelessTerminalItem) {
            WirelessTerminalItem wireless = (WirelessTerminalItem)item;
            try {
                WirelessTerminalMenuHost host = new WirelessTerminalMenuHost((Player)player, null, terminal, (p, menu) -> {});
                if (!host.rangeCheck()) {
                    player.m_5661_((Component)PlayerMessages.OutOfRange.text(), true);
                    return null;
                }
                double power = wireless.getAECurrentPower(terminal);
                if (power <= 0.0) {
                    player.m_5661_((Component)PlayerMessages.DeviceNotPowered.text(), true);
                    return null;
                }
                return host.getInventory();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

