/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import thetadev.constructionwand.ConstructionWand;

public class PacketPreviewResult {
    public final Set<BlockPos> previewBlocks;

    public PacketPreviewResult(Set<BlockPos> previewBlocks) {
        this.previewBlocks = new HashSet<BlockPos>(previewBlocks);
    }

    private PacketPreviewResult(HashSet<BlockPos> previewBlocks) {
        this.previewBlocks = previewBlocks;
    }

    public static void encode(PacketPreviewResult msg, FriendlyByteBuf buffer) {
        for (BlockPos pos : msg.previewBlocks) {
            buffer.m_130064_(pos);
        }
    }

    public static PacketPreviewResult decode(FriendlyByteBuf buffer) {
        HashSet<BlockPos> previewBlocks = new HashSet<BlockPos>();
        while (buffer.isReadable()) {
            previewBlocks.add(buffer.m_130135_());
        }
        return new PacketPreviewResult(previewBlocks);
    }

    public static class Handler {
        public static void handle(PacketPreviewResult msg, Supplier<NetworkEvent.Context> ctx) {
            if (!ctx.get().getDirection().getReceptionSide().isClient()) {
                return;
            }
            ConstructionWand.instance.renderBlockPreview.previewBlocks = msg.previewBlocks;
            ctx.get().setPacketHandled(true);
        }
    }
}

