/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.network.PacketPreviewResult;
import thetadev.constructionwand.wand.WandJob;

public class PacketRequestPreview {
    private final BlockHitResult rtr;
    private final ItemStack wand;

    public PacketRequestPreview(BlockHitResult rtr, ItemStack wand) {
        this.rtr = rtr;
        this.wand = wand;
    }

    public static void encode(PacketRequestPreview msg, FriendlyByteBuf buf) {
        buf.m_130055_(msg.wand);
        buf.m_130062_(msg.rtr);
    }

    public static PacketRequestPreview decode(FriendlyByteBuf buf) {
        ItemStack wand = buf.m_130267_();
        BlockHitResult rtr = buf.m_130283_();
        return new PacketRequestPreview(rtr, wand);
    }

    public static class Handler {
        public static void handle(PacketRequestPreview msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                WandJob job = ItemWand.getWandJob((Player)player, player.m_9236_(), msg.rtr, msg.wand);
                Set<BlockPos> blocks = job.getBlockPositions();
                ConstructionWand.instance.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPreviewResult(blocks));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

