/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.adventureloot;

import net.a5ho9999.adventureloot.config.AdventureLootConfig;
import net.a5ho9999.adventureloot.events.LootTables;
import net.a5ho9999.adventureloot.events.ServerSideUsage;
import net.a5ho9999.adventureloot.registry.AdventureLootModItem;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdventureLootMod
implements ModInitializer {
    public static final String ModId = "adventure-loot";
    public static final AdventureLootConfig Config = AdventureLootConfig.createAndLoad();
    private static final Logger Logger = LoggerFactory.getLogger((String)"adventure-loot");

    public void onInitialize() {
        AdventureLootMod.onLog("Loading Adventure Loot");
        AdventureLootMod.OnDebug("WARNING: Debug Mode is enabled, disable this unless you know what you are doing. It will produce a lot of log messages");
        if (Config.ServerSideOnly()) {
            AdventureLootMod.onLog("Loading in Server-side Mode...");
            AdventureLootMod.CheckValidItems();
            ServerSideUsage.UseItem();
        } else {
            AdventureLootMod.onLog("Loading in Full Mode...");
            AdventureLootModItem.LoadThis();
        }
        LootTables.AddLootBags();
        AdventureLootMod.onLog("Successfully loaded Adventure Loot");
    }

    public static void CheckValidItems() {
        String commonString = Config.ServerSideCommonItem();
        String rareString = Config.ServerSideCommonItem();
        String epicString = Config.ServerSideCommonItem();
        String legendaryString = Config.ServerSideCommonItem();
        AdventureLootMod.OnDebug("Checking Server-side Items against Registry");
        if (class_7923.field_41178.method_17966(class_2960.method_12829((String)commonString)).isEmpty()) {
            Config.ServerSideCommonItem("minecraft:white_dye");
            AdventureLootMod.OnDebug("Invalid Item for Common Bag, reset to White Dye");
        }
        if (class_7923.field_41178.method_17966(class_2960.method_12829((String)rareString)).isEmpty()) {
            Config.ServerSideCommonItem("minecraft:blue_dye");
            AdventureLootMod.OnDebug("Invalid Item for Rare Bag, reset to Blue Dye");
        }
        if (class_7923.field_41178.method_17966(class_2960.method_12829((String)epicString)).isEmpty()) {
            Config.ServerSideCommonItem("minecraft:red_dye");
            AdventureLootMod.OnDebug("Invalid Item for Epic Bag, reset to Red Dye");
        }
        if (class_7923.field_41178.method_17966(class_2960.method_12829((String)legendaryString)).isEmpty()) {
            Config.ServerSideCommonItem("minecraft:purple_dye");
            AdventureLootMod.OnDebug("Invalid Item for Legendary Bag, reset to Purple Dye");
        }
        Config.save();
        AdventureLootMod.OnDebug("Server-side Items validated");
    }

    @NotNull
    public static class_1935 GetServerCommonBag() {
        return (class_1935)class_7923.field_41178.method_63535(class_2960.method_12829((String)Config.ServerSideCommonItem()));
    }

    @NotNull
    public static class_1935 GetServerRareBag() {
        return (class_1935)class_7923.field_41178.method_63535(class_2960.method_12829((String)Config.ServerSideRareItem()));
    }

    @NotNull
    public static class_1935 GetServerEpicBag() {
        return (class_1935)class_7923.field_41178.method_63535(class_2960.method_12829((String)Config.ServerSideEpicItem()));
    }

    @NotNull
    public static class_1935 GetServerLegendaryBag() {
        return (class_1935)class_7923.field_41178.method_63535(class_2960.method_12829((String)Config.ServerSideLegendaryItem()));
    }

    public static void onLog(String message) {
        Logger.info(message);
    }

    public static void OnDebug(String message) {
        if (Config.Debug()) {
            AdventureLootMod.onLog(message);
        }
    }
}

